<?php
define('VAL_REQUIRED', 'This field is required. Please enter a value.');
define('VAL_REQUIRED_FILE', 'This field is required. Please upload a file.');
define('VAL_UNIQUE', 'This field requires a unique entry and this value has already been used.');
define('VAL_INTEGER', 'This field must be an integer.');
define('VAL_FLOAT', 'This field must be a float.');
define('VAL_NUMERIC', 'This field must be a number.');
define('VAL_MIN', 'This field can not be less than %s characters.');
define('VAL_MAX', 'This field can not be greater than %s characters.');
define('VAL_RANGE', 'This field is not in the range %s through %s characters.');
define('VAL_EMAIL', 'This field is not in the correct email format.');
define('VAL_WEBSITE', 'This field is not in the correct website address format.');
define('VAL_USERNAME', 'This field may only consist of a-z 0-9 and underscores.');
define('VAL_EQUAL', '%s must match.');
define('VAL_DATE', 'This field is not in the correct date format.');
define('VAL_TIME', 'This field is not in the correct time format.');
define('VAL_PHONE', 'Please enter a valid phone number.');
function validate_required($value)
{
				$value = $value[0];
				if (empty($value) && (($value != 0) || ($value != '0')))
				{
								return VAL_REQUIRED;
				}
				else
				{
								return true;
				}
}
function validate_unique($value)
{
				$input_value = $value[0];
				$exploded = explode('#', $value[1]);
				$form_id = $exploded[0];
				$element_name = $exploded[1];
				$result = do_query("select count($element_name) total from ap_form_{$form_id} where $element_name='$input_value' ");
				$row = do_fetch_result($result);
				if (!empty($row['total']))
				{
								return VAL_UNIQUE;
				}
				else
				{
								return true;
				}
}
function validate_integer($value)
{
				$error_message = VAL_INTEGER;
				$value = $value[0];
				if (is_int($value))
				{
								return true;
				}
				else
								if (is_float($value))
								{
												return $error_message;
								}
								else
												if (is_numeric($value))
												{
																$result = strpos($value, '.');
																if ($result !== false)
																{
																				return $error_message;
																}
																else
																{
																				return true;
																}
												}
												else
												{
																return $error_message;
												}
}
function validate_float($value)
{
				$error_message = VAL_FLOAT;
				$value = $value[0];
				if (is_int($value))
				{
								return $error_message;
				}
				else
								if (is_float($value))
								{
												return true;
								}
								else
												if (is_numeric($value))
												{
																$result = strpos($value, '.');
																if ($result !== false)
																{
																				return true;
																}
																else
																{
																				return $error_message;
																}
												}
												else
												{
																return $error_message;
												}
}
function validate_numeric($value)
{
				$error_message = VAL_NUMERIC;
				$value = $value[0];
				if (is_numeric($value))
				{
								return true;
				}
				else
				{
								return $error_message;
				}
}
function validate_phone($value)
{
				$error_message = VAL_PHONE;
				if (!empty($value[0]))
				{
								$regex = '/^[1-9][0-9]{9}$/';
								$result = preg_match($regex, $value[0]);
								if (empty($result))
								{
												return $error_message;
								}
								else
								{
												return true;
								}
				}
				else
				{
								return true;
				}
}
function validate_simple_phone($value)
{
				$error_message = VAL_PHONE;
				if ($value[0]{0} == '+')
				{
								$test_value = substr($value[0], 1);
				}
				else
				{
								$test_value = $value[0];
				}
				if (is_numeric($test_value) && (strlen($test_value) > 3))
				{
								return true;
				}
				else
				{
								return $error_message;
				}
}
function validate_min($value)
{
				$error_message = VAL_MIN;
				if (strlen($value[0]) < $value[1])
				{
								return sprintf($error_message, $value[1]);
				}
				else
				{
								return true;
				}
}
function validate_max($value)
{
				$error_message = VAL_MAX;
				if (strlen($value[0]) > $value[1])
				{
								return sprintf($error_message, $value[1]);
				}
				else
				{
								return true;
				}
}
function validate_range($value)
{
				$error_message = VAL_RANGE;
				$exp_array = explode('-', $value[1]);
				$min = $exp_array[0];
				$max = $exp_array[1];
				if (!((strlen($value[0]) >= $min) && (strlen($value[0]) <= $max)))
				{
								return sprintf($error_message, '%s', $min, $max);
				}
				else
				{
								return true;
				}
}
function validate_email($value)
{
				$error_message = VAL_EMAIL;
				if (!empty($value[0]))
				{
								$regex = '/^[A-z0-9][\w.-]*@[A-z0-9][\w\-\.]+\.[A-z0-9]{2,6}$/';
								$result = preg_match($regex, $value[0]);
								if (empty($result))
								{
												return sprintf($error_message, '%s', $value[0]);
								}
								else
								{
												return true;
								}
				}
				else
				{
								return true;
				}
}
function validate_website($value)
{
				$error_message = VAL_WEBSITE;
				if (!empty($value[0]))
				{
								$regex = '/^https?:\/\/([a-z0-9]([-a-z0-9]*[a-z0-9])?\.)+((a[cdefgilmnoqrstuwxz]|aero|arpa)|(b[abdefghijmnorstvwyz]|biz)|(c[acdfghiklmnorsuvxyz]|cat|com|coop)|d[ejkmoz]|(e[ceghrstu]|edu)|f[ijkmor]|(g[abdefghilmnpqrstuwy]|gov)|h[kmnrtu]|(i[delmnoqrst]|info|int)|(j[emop]|jobs)|k[eghimnprwyz]|l[abcikrstuvy]|(m[acdghklmnopqrstuvwxyz]|mil|mobi|museum)|(n[acefgilopruz]|name|net)|(om|org)|(p[aefghklmnrstwy]|pro)|qa|r[eouw]|s[abcdeghijklmnortvyz]|(t[cdfghjklmnoprtvwz]|travel)|u[agkmsyz]|v[aceginu]|w[fs]|y[etu]|z[amw])$/i';
								$result = preg_match($regex, $value[0]);
								if (empty($result))
								{
												return sprintf($error_message, '%s', $value[0]);
								}
								else
								{
												return true;
								}
				}
				else
				{
								return true;
				}
}
function validate_username($value)
{
				$error_message = VAL_USERNAME;
				if (!preg_match("/^[a-z0-9][\w]*$/i", $value[0]))
				{
								return sprintf($error_message, '%s', $value[0]);
				}
				else
				{
								return true;
				}
}
function validate_equal($value)
{
				$error_message = VAL_EQUAL;
				if ($value[0] != $value[2][$value[1]])
				{
								return $error_message;
				}
				else
				{
								return true;
				}
}
function validate_date($value)
{
				$error_message = VAL_DATE;
				if (!empty($value[0]))
				{
								if ($value[1] == 'yyyy/mm/dd')
								{
												$regex = "/^([1-9][0-9])\d\d[-\/](0?[1-9]|1[012])[-\/](0?[1-9]|[12][0-9]|3[01])$/";
								} elseif ($value[1] == 'mm/dd/yyyy')
								{
												$regex = "/^(0[1-9]|1[012])[-\/](0[1-9]|[12][0-9]|3[01])[-\/](19|20)\d\d$/";
								}
								$result = preg_match($regex, $value[0]);
				}
				if (empty($result))
				{
								return sprintf($error_message, '%s', $value[1]);
				}
				else
				{
								return true;
				}
}
function validate_time($value)
{
				$error_message = VAL_TIME;
				$timestamp = strtotime($value[0]);
				if ($timestamp == -1 || $timestamp === false)
				{
								return $error_message;
				}
				else
				{
								return true;
				}
}
function validate_required_file($value)
{
				$error_message = VAL_REQUIRED_FILE;
				$element_file = $value[0];
				if ($_FILES[$element_file]['size'] > 0)
				{
								return true;
				}
				else
				{
								return $error_message;
				}
}
function validate_rules($input, $rules)
{
				foreach ($input as $key => $value)
				{
								$current_rules = @$rules[$key];
								$error_message = array();
								if (!empty($current_rules))
								{
												foreach ($current_rules as $key2 => $value2)
												{
																$argument_array = array($value, $value2, $input);
																$result = call_user_func('validate_' . $key2, $argument_array);
																if ($result !== true)
																{
																				$error_message = $result;
																				break;
																}
												}
								}
								if (count($error_message) > 0)
								{
												$total_error_message[$key] = $error_message;
								}
				}
				if (@is_array($total_error_message))
				{
								return $total_error_message;
				}
				else
				{
								return true;
				}
}
function validate_element($input, $rules)
{
				foreach ($input as $key => $value)
				{
								$current_rules = @$rules[$key];
								$error_message = array();
								if (!empty($current_rules))
								{
												foreach ($current_rules as $key2 => $value2)
												{
																$argument_array = array($value, $value2, $input);
																$result = call_user_func('validate_' . $key2, $argument_array);
																if ($result !== true)
																{
																				$error_message = $result;
																				break;
																}
												}
								}
								if (count($error_message) > 0)
								{
												$last_error_message = $error_message;
												break;
								}
				}
				if (!empty($last_error_message))
				{
								return $last_error_message;
				}
				else
				{
								return true;
				}
}
?>