<?php
require('../fpdf/fpdf.php');
require_once('../../Connections/conexion.php');
require_once('../../main/libreria.php');

class PDF extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
	//Set the array of column widths
	$this->widths=$w;
}

function SetAligns($a)
{
	//Set the array of column alignments
	$this->aligns=$a;
}

function Row($data)
{
	//Calculate the height of the row
	$nb=0;
	for($i=0;$i<count($data);$i++)
		$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
	$h=5*$nb;
	//Issue a page break first if needed
	$this->CheckPageBreak($h);
	//Draw the cells of the row
	for($i=0;$i<count($data);$i++)
	{
		$w=$this->widths[$i];
		$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
		//Save the current position
		$x=$this->GetX();
		$y=$this->GetY();
		//Draw the border
		
		$this->Rect($x,$y,$w,$h);

		$this->MultiCell($w,5,$data[$i],0,$a,'true');
		//Put the position to the right of the cell
		$this->SetXY($x+$w,$y);
	}
	//Go to the next line
	$this->Ln($h);
}

function CheckPageBreak($h)
{
	//If the height h would cause an overflow, add a new page immediately
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
	//Computes the number of lines a MultiCell of width w will take
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
}

function Header()
{

	$this->SetFont('Arial','B',8);
	$this->Text(20,14,'APORTE IESS EMPLEADOS',0,'C', 0);
	$this->SetFont('Arial','',6);
	$this->Text(200,10,$this->PageNo(),0,'C', 0);
	$this->Ln(5);
}

function Footer()
{
	$this->SetY(-15);
	$this->SetFont('Arial','B',8);
	$this->Cell(100,10,'',0,0,'L');

}

}

	
	$desde= $_GET['fdesde'];
	$hasta= $_GET['fhasta'];
	$empleado= $_GET['emp'];
	
	//$con = new DB;
	//$pacientes = $con->conectar();	
	
	if ($desde<'2011-02-01')
	$desde='2011-02-01';
	
	
				mysql_select_db($database_conexion, $conexion);
$sqlq="SELECT SUBSTRING_INDEX(emp_nombre, ' ', 1) as emp_nombre, SUBSTRING_INDEX(emp_apellido, ' ', 1) as emp_apellido, usu_cod from usuario inner join empleado on emp_codigo = usu_empleado where usu_nick = '$usuario'";
$sql = mysql_query($sqlq, $conexion) or die(mysql_error());
$row_sql = mysql_fetch_assoc($sql);
$emp = parametros($database_conexion, $conexion, 'nombre_empresa');
	
	

	$pdf=new PDF('P','mm','A4');
	$pdf->Open();
	$pdf->AddPage();
	$pdf->SetMargins(20,20,20);
	$pdf->Ln(1);

    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,6,'EMPRESA: '.$emp,0,1);
	$pdf->Cell(0,6,'DESDE: '.$desde,0,1);
	$pdf->Cell(0,6,'HASTA: '.$hasta,0,1);
	
	
	
	
	
	$pdf->Ln(2);
	
	$pdf->SetWidths(array(10,45,15,15,40,40,20));
	$pdf->SetFont('Arial','B',6);
	$pdf->SetFillColor(104,131,139);
    $pdf->SetTextColor(255);

		for($i=0;$i<1;$i++)
			{
				$pdf->Row(array('COD', 'EMPLEADO','FECHA','IESS', 'APORTE PATRONAL', 'TOTAL'  ));
			}
	
    $emp_codigo=$_GET['emp'];
	$desde=$_GET['fdesde'];
	$hasta=$_GET['fhasta'];
	mysql_select_db($database_conexion, $conexion);
	$strConsulta = "select emp_codigo as codigo,concat(emp_apellido,' ',emp_nombre)as empleado,empleado_egrempleado.fecha,round(apiess,2) as apiess, round(appatronal,2) as appatronal, round(apiess + appatronal,2) as total
from empleado
INNER JOIN empleado_egrempleado ON empleado_egrempleado.fecha between '".$desde."' and '".$hasta."'
AND empleado_egrempleado.codempleado=emp_codigo AND empleado_egrempleado.codrol=codrol
INNER JOIN empleado_provisiones ON empleado_provisiones.fecha between '".$desde."' and '".$hasta."'
AND empleado_provisiones.codempleado=emp_codigo AND empleado_provisiones.codrol=empleado_egrempleado.codrol
where emp_codigo=$emp_codigo";
	
if ($empleado!=0)
$strConsulta=$strConsulta. " and emp_codigo=".$empleado;

$strConsulta=$strConsulta. " order by empleado,fecha";

$historial = mysql_query($strConsulta);
$numfilas = mysql_num_rows($historial);

	
	$suma=0;
	$sumap=0;
	$total=0;
	
	for ($i=0; $i<$numfilas; $i++)
		{
			
			$fila = mysql_fetch_array($historial);
			$pdf->SetFont('Arial','',6);
			
		
			
			if($i%2 == 1)
			{
				$pdf->SetFillColor(230,230,230);
    			$pdf->SetTextColor(0);
				$pdf->Row(array($fila['codigo'], $fila['empleado'], $fila['fecha'], $fila['apiess'], $fila['appatronal'], $fila['total']));
			}
			else
			{
				$pdf->SetFillColor(255,255,255);
    			$pdf->SetTextColor(0);
				$pdf->Row(array($fila['codigo'], $fila['empleado'], $fila['fecha'], $fila['apiess'], $fila['appatronal'], $fila['total']));
			}
			
			
			$suma=$suma+$fila['apiess'];
			$sumap=$suma+$fila['appatronal'];
			$total=$total+$fila['total'];
			
		}
		
		$pdf->SetFont('Arial','B',7);
		$pdf->Row(array('', 'TOTALES:', '', $suma,$sumap,$total));

$pdf->Output();
?>