function apSetCookie(c_name,value,expiredays)
{
	var exdate=new Date();
	exdate.setDate(exdate.getDate()+expiredays);
	document.cookie=c_name+ "=" +escape(value)+
	((expiredays==null) ? "" : ";expires="+exdate.toGMTString());
}

function apGetCookie(c_name)
{
	if (document.cookie.length>0)
	{
		c_start=document.cookie.indexOf(c_name + "=");
		if (c_start!=-1)
		{ 
			c_start=c_start + c_name.length+1; 
			c_end=document.cookie.indexOf(";",c_start);
			if (c_end==-1) c_end=document.cookie.length;
			return unescape(document.cookie.substring(c_start,c_end));
		} 
	}
	return "";
}

function apSetLoginCookie()
{
	apSetCookie('ap_gotostartpage', 1, 7);
	apSetCookie('ap_loginpagelocation', document.location.href, 7);
}

function apSetStartPage(anchor)
{
	apSetCookie('ap_startpage', document.location.href, 7);
	var myFx = new Fx.Style(anchor, 'opacity');
	myFx.start(0,1);
}

function apShowQuickLaunch(anchor, title)
{
	var apQuickLaunchDiv = $('apquicklaunch' + title);
	anchor = $(anchor);
	var anchorCoords = anchor.getCoordinates();
	var divCoords;
	anchor.quickLaunchTitle = title;

	if(apQuickLaunchDiv.getStyle('display') == 'none')
	{
		anchor.addEvent('mouseleave', apHideQuickLaunch);
		apQuickLaunchDiv.addEvent('mouseleave', apHideQuickLaunch);
		apQuickLaunchDiv.setStyle('z-index', '1234');
		apQuickLaunchDiv.setStyle('position', 'absolute');
		apQuickLaunchDiv.setStyle('opacity', 0);
		apQuickLaunchDiv.setStyle('display', '');

		// Move our div to be below our anchor and centered on it
		divCoords = apQuickLaunchDiv.getCoordinates();
		apQuickLaunchDiv.setStyle('top', (anchorCoords.top + anchorCoords.height) + 'px');
		apQuickLaunchDiv.setStyle('left', (anchorCoords.left + anchorCoords.width/2 - divCoords.width/2) + 'px');
		divCoords = apQuickLaunchDiv.getCoordinates();

		// Make sure we don't go over the sides
		if((divCoords.left + divCoords.width) > window.getWidth())
		{
			apQuickLaunchDiv.setStyle('left', (window.getWidth() - divCoords.width) + 'px');
		}
		if(divCoords.left < 0)
		{
			apQuickLaunchDiv.setStyle('left', '0px');
		}
	
		apQuickLaunchDiv.effect('opacity', {
			duration: apQuickLaunchOpenDuration
		}).start(0, 1);
	}
}

function apHideQuickLaunch(event)
{
	var apQuickLaunchDiv;
	if(this && this.tagName.toLowerCase() == 'a')
	{
		apQuickLaunchDiv = $('apquicklaunch' + this.quickLaunchTitle);

		// If we moved from the anchor to the div, don't close.
		if(event.relatedTarget == apQuickLaunchDiv)
		{
			return;
		}
	}
	else
	{
		apQuickLaunchDiv = this;

		// If we moved from the div to the anchor, don't close.
		if('apquicklaunch' + event.relatedTarget.quickLaunchTitle == apQuickLaunchDiv.id)
		{
			return;
		}
	}
	apQuickLaunchDiv.hideEffect = apQuickLaunchDiv.effect('opacity', {
		onComplete: function(element) {
			element.setStyle('display', 'none');
			element.setStyle('opacity', 1);
			element.removeEvent('mouseleave', apHideQuickLaunch);
		},
		onCancel: function(element) {
			element.setStyle('opacity', 1);
		},
		duration: apQuickLaunchOpenDuration
	});
	apQuickLaunchDiv.addEvent('mouseenter', apCancelHideQuickLaunch);
	apQuickLaunchDiv.hideEffect.start(1, 0);
}

function apCancelHideQuickLaunch(event)
{
	this.hideEffect.stop();
	this.removeEvent('mouseenter', apCancelHideQuickLaunch);
}

