<?php
/******************************************************************************
 MachForm
  
 Copyright 2007 Appnitro Software. This code cannot be redistributed without
 permission from http://www.appnitro.com/
 
 More info at: http://www.appnitro.com/
 ******************************************************************************/
	
	//this function accept 'YYYY-MM-DD HH:MM:SS'
	function relative_date($input_date) {
	    
	    $tz = 0;    // change this if your web server and weblog are in different timezones
	           			        
	    $posted_date = str_replace(array('-',' ',':'),'',$input_date);            
	    $month = substr($posted_date,4,2);
	    
	    if ($month == "02") { // february
	    	// check for leap year
	    	$leapYear = isLeapYear(substr($posted_date,0,4));
	    	if ($leapYear) $month_in_seconds = 2505600; // leap year
	    	else $month_in_seconds = 2419200;
	    }
	    else { // not february
	    // check to see if the month has 30/31 days in it
	    	if ($month == "04" or 
	    		$month == "06" or 
	    		$month == "09" or 
	    		$month == "11")
	    		$month_in_seconds = 2592000; // 30 day month
	    	else $month_in_seconds = 2678400; // 31 day month;
	    }
	  
	    $in_seconds = strtotime(substr($posted_date,0,8).' '.
	                  substr($posted_date,8,2).':'.
	                  substr($posted_date,10,2).':'.
	                  substr($posted_date,12,2));
	    $diff = time() - ($in_seconds + ($tz*3600));
	    $months = floor($diff/$month_in_seconds);
	    $diff -= $months*2419200;
	    $weeks = floor($diff/604800);
	    $diff -= $weeks*604800;
	    $days = floor($diff/86400);
	    $diff -= $days*86400;
	    $hours = floor($diff/3600);
	    $diff -= $hours*3600;
	    $minutes = floor($diff/60);
	    $diff -= $minutes*60;
	    $seconds = $diff;
	
	    if ($months>0) {
	        // over a month old, just show date ("Month, Day Year")
	        if(!empty($input_date)){
	        	return date('F jS, Y',strtotime($input_date));
	        }else{
	        	return 'N/A';
	        }
	    } else {
	        if ($weeks>0) {
	            // weeks and days
	            $relative_date .= ($relative_date?', ':'').$weeks.' week'.($weeks>1?'s':'');
	            $relative_date .= $days>0?($relative_date?', ':'').$days.' day'.($days>1?'s':''):'';
	        } elseif ($days>0) {
	            // days and hours
	            $relative_date .= ($relative_date?', ':'').$days.' day'.($days>1?'s':'');
	            $relative_date .= $hours>0?($relative_date?', ':'').$hours.' hour'.($hours>1?'s':''):'';
	        } elseif ($hours>0) {
	            // hours and minutes
	            $relative_date .= ($relative_date?', ':'').$hours.' hour'.($hours>1?'s':'');
	            $relative_date .= $minutes>0?($relative_date?', ':'').$minutes.' minute'.($minutes>1?'s':''):'';
	        } elseif ($minutes>0) {
	            // minutes only
	            $relative_date .= ($relative_date?', ':'').$minutes.' minute'.($minutes>1?'s':'');
	        } else {
	            // seconds only
	            $relative_date .= ($relative_date?', ':'').$seconds.' second'.($seconds>1?'s':'');
	        }
	        
	        // show relative date and add proper verbiage
	    	return $relative_date.' ago';
	    }
	    
	}
	
	function isLeapYear($year) {
	        return $year % 4 == 0 && ($year % 400 == 0 || $year % 100 != 0);
	}
	
	//remove a folder and all it's content
	function full_rmdir($dirname){
        if ($dirHandle = opendir($dirname)){
            $old_cwd = getcwd();
            chdir($dirname);

            while ($file = readdir($dirHandle)){
                if ($file == '.' || $file == '..') continue;

                if (is_dir($file)){
                    if (!full_rmdir($file)) return false;
                }else{
                    if (!unlink($file)) return false;
                }
            }

            closedir($dirHandle);
            chdir($old_cwd);
            if (!rmdir($dirname)) return false;

            return true;
        }else{
            return false;
        }
    }

    //show success or error messages
    function show_message(){
    	
    	if(!empty($_SESSION['AP_ERROR'])){
    		if(!empty($_SESSION['AP_ERROR']['desc'])){
    			$error_desc = '<p id="error_message_desc"><b>'.$_SESSION['AP_ERROR']['desc'].'</b></p>';
    		}else{
    			$error_desc = '';
    		}
    		
    		$ul_markup =<<<EOT
			<ul class="global_message">
				<li id="error_message">
					<h3 id="error_message_title">{$_SESSION['AP_ERROR']['title']} &nbsp;<img src="images/icons/stop.gif" align="top" style="padding-top: 2px"/></h3>
					{$error_desc}
				</li>	
			</ul>
EOT;

    		echo $ul_markup;
    		
    		$_SESSION['AP_ERROR'] = array();
    		unset($_SESSION['AP_ERROR']);
    	}
    	
    	if(!empty($_SESSION['AP_SUCCESS'])){
    		if(!empty($_SESSION['AP_SUCCESS']['desc'])){
    			$success_desc = '<p id="success_message_desc"><b>'.$_SESSION['AP_SUCCESS']['desc'].'</b></p>';
    		}else{
    			$success_desc = '';
    		}
    		
    		$ul_markup =<<<EOT
			<ul class="global_message">
				<li id="success_message">
					<h3 id="success_message_title"><span>{$_SESSION['AP_SUCCESS']['title']}&nbsp;<img src="images/icons/checkbox.gif" align="absmiddle" /></span></h3>
					{$success_desc}
				</li>	
			</ul>
EOT;

    		echo $ul_markup;
    		
			$_SESSION['AP_SUCCESS'] = array();
    		unset($_SESSION['AP_SUCCESS']);
		}
	    	
    }
    
    
    function send_notification($form_id,$table_data){
									
    		//first, reorder table data into the correct position
    		$query = "select 
    						element_id,
    						element_total_child 
    					from 
    						`ap_form_elements`
    				   where 
    				   		form_id='$form_id' 
    				order by 
    						element_position asc";
    		$result = do_query($query);
			
    		while($row = do_fetch_result($result)){
				$element_id  = $row['element_id'];
				$total_child = $row['element_total_child'];
				
				if($total_child > 0){
					
					$max = $total_child + 1;
					for($i=0;$i<=$max;$i++){
						if($i == 0){
							if(array_key_exists('element_'.$element_id,$table_data)){
								$temp_table_data['element_'.$element_id] = $table_data['element_'.$element_id];
							}
						}else{
							
							if(array_key_exists('element_'.$element_id.'_'.$i,$table_data)){
								$temp_table_data['element_'.$element_id.'_'.$i] = $table_data['element_'.$element_id.'_'.$i];
							}
						}
					}
				}else{
					$temp_table_data['element_'.$element_id] = $table_data['element_'.$element_id];
				}
			}
    		
			$table_data = array();
			$table_data = $temp_table_data;
			
			//get form properties
			$query 	= "select 
						 	form_name,
						 	form_email
					 	from 
				     	 	`ap_forms` 
				       where 
				    	 	form_id='$form_id'";
			$result = do_query($query);
			$row 	= do_fetch_result($result);
			$form_name  = $row['form_name'];
			$form_email = $row['form_email'];
			
			//get entry count
			$query = "select count(*) total_entry from `ap_form_{$form_id}`";
			$result = do_query($query);
			$row 	= do_fetch_result($result);
			$form_entry_no = $row['total_entry'] + 1;

			//get form element options
			$query = "select element_id,option_id,`option` from ap_element_options where form_id='$form_id' and live=1";
			$result = do_query($query);
			while($row = do_fetch_result($result)){
				$element_id = $row['element_id'];
				$option_id  = $row['option_id'];
				
				$element_option_lookup[$element_id][$option_id] = htmlspecialchars($row['option'],ENT_QUOTES);
			}
			
					
			//get form field name lookup
			$query  = "select element_id,element_title,element_type,element_constraint from `ap_form_elements` where form_id='$form_id' order by element_position asc";			$result = do_query($query);
			
			while($row = do_fetch_result($result)){
				$element_type = $row['element_type'];
				$element_constraint = $row['element_constraint'];
				
								
				if('address' == $element_type){ //address has 6 fields
					$column_name_lookup['element_'.$row['element_id'].'_1'] = $row['element_title'].' - Street Address';
					$column_name_lookup['element_'.$row['element_id'].'_2'] = 'Address Line 2';
					$column_name_lookup['element_'.$row['element_id'].'_3'] = 'City';
					$column_name_lookup['element_'.$row['element_id'].'_4'] = 'State/Province/Region';
					$column_name_lookup['element_'.$row['element_id'].'_5'] = 'Zip/Postal Code';
					$column_name_lookup['element_'.$row['element_id'].'_6'] = 'Country';
					
					$column_type_lookup['element_'.$row['element_id'].'_1'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_2'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_3'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_4'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_5'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_6'] = $row['element_type'];
					
				}elseif ('simple_name' == $element_type){ //simple name has 2 fields
					$column_name_lookup['element_'.$row['element_id'].'_1'] = $row['element_title'].' - First';
					$column_name_lookup['element_'.$row['element_id'].'_2'] = $row['element_title'].' - Last';
					
					$column_type_lookup['element_'.$row['element_id'].'_1'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_2'] = $row['element_type'];
					
				}elseif ('name' == $element_type){ //name has 4 fields
					$column_name_lookup['element_'.$row['element_id'].'_1'] = $row['element_title'].' - Title';
					$column_name_lookup['element_'.$row['element_id'].'_2'] = $row['element_title'].' - First';
					$column_name_lookup['element_'.$row['element_id'].'_3'] = $row['element_title'].' - Last';
					$column_name_lookup['element_'.$row['element_id'].'_4'] = $row['element_title'].' - Suffix';
					
					$column_type_lookup['element_'.$row['element_id'].'_1'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_2'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_3'] = $row['element_type'];
					$column_type_lookup['element_'.$row['element_id'].'_4'] = $row['element_type'];
					
				}elseif('money' == $element_type){//money format
					$column_name_lookup['element_'.$row['element_id']] = $row['element_title'];
					if(!empty($element_constraint)){
						$column_type_lookup['element_'.$row['element_id']] = $element_constraint; //euro, pound, yen
					}else{
						$column_type_lookup['element_'.$row['element_id']] = 'dollar'; //default is dollar
					}
				}elseif('checkbox' == $element_type){ //checkboxes, get childs elements
								
					$this_checkbox_options = $element_option_lookup[$row['element_id']];
					foreach ($this_checkbox_options as $option_id=>$option){
						$column_name_lookup['element_'.$row['element_id'].'_'.$option_id] = $option;
						$column_type_lookup['element_'.$row['element_id'].'_'.$option_id] = $row['element_type'];
					}
				}else{ //for other elements with only 1 field
					$column_name_lookup['element_'.$row['element_id']] = $row['element_title'];
					$column_type_lookup['element_'.$row['element_id']] = $row['element_type'];
				}
			}
			
			unset($table_data['ip_address']);
			unset($table_data['date_created']);
			
			//get column name for each input
			$i=0;
			foreach ($table_data as $column_name=>$value){
				
				$email_data[$i]['label'] = $column_name_lookup[$column_name];
				
				if($column_type_lookup[$column_name] == 'time'){
					if(!empty($value)){
						$email_data[$i]['value'] = ' - '.date("h:i:s A",strtotime($value));
					}else{
						$email_data[$i]['value'] = '';
					}
				}elseif(in_array($column_type_lookup[$column_name],array('dollar','euro','pound','yen'))){ //set column formatting for money fields
					$currency = $column_type_lookup[$column_name];
					if($currency == 'dollar'){
						$email_data[$i]['value'] = ' - $'.$value;
					}elseif ($currency == 'euro'){
						$email_data[$i]['value'] = ' - &#8364;'.$value;
					}elseif ($currency == 'pound'){
						$email_data[$i]['value'] = ' - &#163;'.$value;
					}elseif ($currency == 'yen'){
						$email_data[$i]['value'] = ' - &#165;'.$value;
					}	
				}elseif($column_type_lookup[$column_name] == 'date'){ //date with format MM/DD/YYYY
					if(!empty($value) && ($value != '0000-00-00')){
						$exploded_value = array();
						$exploded_value = explode("-",$value);
						$email_data[$i]['value']  = ' - '."{$exploded_value[1]}/{$exploded_value[2]}/{$exploded_value[0]}";
					}else{
						$email_data[$i]['value']  = '';
					}
				}elseif($column_type_lookup[$column_name] == 'europe_date'){ //date with format DD/MM/YYYY
					if(!empty($value) && ($value != '0000-00-00')){
						$exploded_value = array();
						$exploded_value = explode("-",$value);
						$email_data[$i]['value']  = ' - '."{$exploded_value[2]}/{$exploded_value[1]}/{$exploded_value[0]}";
					}else{
						$email_data[$i]['value']  = '';
					}
				}elseif (in_array($column_type_lookup[$column_name],array('radio','select'))){ //multiple choice or dropdown
					$exploded = array();
					$exploded = explode('_',$column_name);
					$this_element_id = $exploded[1];
					$this_option_id  = $value;
					
					if(!empty($value)){
						$email_data[$i]['value']  = ' - '.$element_option_lookup[$this_element_id][$this_option_id];
					}else{
						$email_data[$i]['value']  = '';
					}
				}elseif($column_type_lookup[$column_name] == 'checkbox'){
					if(!empty($value)){
						$email_data[$i]['value'] = ' - '.'Yes';
					}else{
						$email_data[$i]['value'] = '';
					}
					
				}elseif(in_array($column_type_lookup[$column_name],array('phone','simple_phone'))){ 
					if($column_type_lookup[$column_name] == 'phone'){
						if(!empty($value)){
							$email_data[$i]['value'] = ' - '.'('.substr($value,0,3).') '.substr($value,3,3).'-'.substr($value,6,4);
						}else{
							$email_data[$i]['value'] = '';
						}
					}else{
						if(!empty($value)){
							$email_data[$i]['value'] = ' - '.$value;
						}else{
							$email_data[$i]['value'] = '';
						}
					}
				}elseif($column_type_lookup[$column_name] == 'file'){
					if(!empty($value)){
						$exploded = array();
						$exploded = explode('#',$value);
						
						//encode the long query string for more readibility
						$q_string = base64_encode("form_id={$form_id}&id={$exploded[0]}&el={$column_name}");
						$email_data[$i]['value'] = '<br /><a href="'."http://".$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']).'/download.php?q='.$q_string.'">'.$exploded[1].'</a>';
					}
									
				}elseif($column_type_lookup[$column_name] == 'textarea'){ 
					if(!empty($value)){
						$email_data[$i]['value'] = "<br />".nl2br(htmlspecialchars($value,ENT_QUOTES))."<br />";
					}else {
						$email_data[$i]['value'] = '';
					}
				}elseif($column_type_lookup[$column_name] == 'email'){ 
					if(!empty($value)){
						$email_data[$i]['value'] = " - <a href=\"mailto:{$value}\">{$value}</a>";
					}else {
						$email_data[$i]['value'] = '';
					}
				}elseif($column_type_lookup[$column_name] == 'url'){ 
					if(!empty($value)){
						$email_data[$i]['value'] = " - <a href=\"{$value}\">{$value}</a>";
					}else {
						$email_data[$i]['value'] = '';
					}
				}else{
					if(!empty($value)){
						$email_data[$i]['value'] = ' - '.htmlspecialchars(str_replace("\r","",str_replace("\n"," ",$value)),ENT_QUOTES);
					}else{
						$email_data[$i]['value'] = '';
					}
				}
							
				$i++;
			}
			
			//prepare HTML body for email
			$email_body = '';
			$i=1;
			foreach ($email_data as $data){
				$email_body .= "{$i}) <b>{$data['label']}</b> {$data['value']} <br />";
				$i++;
			}
			$email_body .= "<br /><br /><br /><br />[iAG] NULLED 2008";
			//prepare alternate body for text
			
			//send email
			$mail = new PHPMailer();
			$domain = str_replace('www.','',$mail->ServerHostname());
			
			if(NOTIFICATION_MAIL_FROM == ''){
				$mail->From     = "no-reply@{$domain}";
			}else{
				$mail->From     = utf8_encode(NOTIFICATION_MAIL_FROM);
			}
			
			if(NOTIFICATION_MAIL_FROM_NAME == ''){
				$mail->FromName = "Web2.0 Forms";
			}else{
				$mail->FromName = utf8_encode(NOTIFICATION_MAIL_FROM_NAME);
			}
			
			$mail->Host     = "127.0.0.1";
			$mail->Mailer   = "mail";
			$mail->CharSet  = 'UTF-8';
						
			if(NOTIFICATION_MAIL_SUBJECT == ''){
				$mail->Subject  = $form_name." [#{$form_entry_no}]";
			}else{
				$subject = utf8_encode(str_replace(array('{form_name}','{entry_no}'),array($form_name,$form_entry_no),NOTIFICATION_MAIL_SUBJECT));
				$mail->Subject  = $subject;
			}	
				
			$email_address = explode(',',$form_email);
			foreach ($email_address as $email){
				$email = trim($email);
				$mail->AddAddress($email);
			}
			
			$mail->IsHTML(true);

			//Mail it
			$mail->Body = $email_body;
			
			$mail->Send();
    		$mail->ClearAddresses();
    		
		}
?>