﻿<!DOCTYPE html>
<html lang="en">
<head>
    <title id='Description'>This example shows how to implement Master-Details binding scenario with two Grids.</title>
    <link rel="stylesheet" href="jqwidgets/styles/jqx.base.css" type="text/css" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta name="viewport" content="width=device-width, initial-scale=1 maximum-scale=1 minimum-scale=1" />
    <script type="text/javascript" src="scripts/jquery-1.11.1.min.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxcore.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxbuttons.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxscrollbar.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxmenu.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.selection.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.columnsresize.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.pager.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxlistbox.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxdropdownlist.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxdata.js"></script>
    <script type="text/javascript" src="scripts/demos.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            // prepare the data
            var source =
            {
                datafields: [
                    { name: 'CustomerID' },
                    { name: 'CompanyName' },
                    { name: 'ContactName' },
                    { name: 'ContactTitle' },
                    { name: 'Address' },
                    { name: 'City' },
                    { name: 'Country' }
                ],
                localdata: [
					
					{ "CustomerID": "ALFKI", "CompanyName": "Alfreds Futterkiste", "ContactName": "Maria Anders", "ContactTitle": "Sales Representative", "Address": "Obere Str. 57", "City": "Berlin", "Country": "Germany" },
					
					{ "CustomerID": "ANATR", "CompanyName": "Ana Trujillo Emparedados y helados", "ContactName": "Ana Trujillo", "ContactTitle": "Owner", "Address": "Avda. de la Constitucin 2222", "City": "Mxico D.F.", "Country": "Mexico" }, 
					
					{ "CustomerID": "ANTON", "CompanyName": "Antonio Moreno Taquera", "ContactName": "Antonio Moreno", "ContactTitle": "Owner", "Address": "Mataderos  2312", "City": "Mxico D.F.", "Region": null, "PostalCode": 05023, "Country": "Mexico" }, 
					
					{ "CustomerID": "AROUT", "CompanyName": "Around the Horn", "ContactName": "Thomas Hardy", "ContactTitle": "Sales Representative", "Address": "120 Hanover Sq.", "City": "London",  "Country": "UK" }
				]
            };
            var dataAdapter = new $.jqx.dataAdapter(source);
            $("#customersGrid").jqxGrid(
            {
                width: getWidth('Grid'),
                height: 250,
                source: dataAdapter,
                
                keyboardnavigation: false,
                columns: [
                    { text: 'Company Name', datafield: 'CompanyName', width: 250 },
                    { text: 'Contact Name', datafield: 'ContactName', width: 150 },
                    { text: 'Contact Title', datafield: 'ContactTitle', width: 180 },
                    { text: 'City', datafield: 'City', width: 120 },
                    { text: 'Country', datafield: 'Country'}
                ]
            });
            // Orders Grid
            // prepare the data
            var dataFields = [
                        { name: 'CustomerID' },
                        { name: 'OrderID' },
                        { name: 'OrderDate', type: 'date' },
                        { name: 'ShippedDate', type: 'date' },
                        { name: 'ShipName' },
                        { name: 'ShipCountry' }
                    ];
            var source =
            {
                datafields: dataFields,
                localdata: [
					{ "OrderID": 10643, "CustomerID": "ALFKI",  "OrderDate": "1997-08-25 00:00:00", "ShippedDate": "1997-09-02 00:00:00", "ShipName": "Alfreds Futterkiste", "ShipCountry": "Germany" }, 
					
									
					{ "OrderID": 10692, "CustomerID": "ALFKI",  "OrderDate": "1997-10-03 00:00:00",  "ShippedDate": "1997-10-13 00:00:00", "ShipName": "Alfred-s Futterkiste","ShipCountry": "Germany" }]
            };
            var dataAdapter = new $.jqx.dataAdapter(source);
            dataAdapter.dataBind();
            $("#customersGrid").on('rowselect', function (event) {
                var customerID = event.args.row.CustomerID;
                var records = new Array();
                var length = dataAdapter.records.length;
                for (var i = 0; i < length; i++) {
                    var record = dataAdapter.records[i];
                    if (record.CustomerID == customerID) {
                        records[records.length] = record;
                    }
                }
                var dataSource = {
                    datafields: dataFields,
                    localdata: records
                }
                var adapter = new $.jqx.dataAdapter(dataSource);
        
                // update data source.
                $("#ordersGrid").jqxGrid({ source: adapter });
            });
            $("#ordersGrid").jqxGrid(
            {
                width: getWidth('Grid'),
                height: 250,
                keyboardnavigation: false,
                columns: [
                    { text: 'OrderID', datafield: 'OrderID', width: 100 },
                    { text: 'OrderDate', datafield: 'OrderDate', cellsformat: 'd', width: 150 },
                    { text: 'Shipped Date', datafield: 'ShippedDate', cellsformat: 'd', width: 150 },
                    { text: 'Ship Name', datafield: 'ShipName' }
                ]
            });
            $("#customersGrid").jqxGrid('selectrow', 0);
        });
    </script>
</head>
<body class='default'>
    <div id='jqxWidget' style="font-size: 13px; font-family: Verdana; float: left;">
        <h3>
            Customers</h3>
        <div id="customersGrid">
        </div>
        <h3>
            Orders by Customer</h3>
        <div id="ordersGrid">
        </div>
    </div>
</body>
</html>