<?php

require_once 'conexion.php';

class Temas extends Conexion {

    public $mysqli;
    public $data;
    private $tTemas;

    public function __construct() {
        $this->mysqli = parent::conectar();
        $this->data = array();
    }

    //*****************************************************************
    // LISTAMOS LOS TEMAS PAGINADOS DEL FORO
    //*****************************************************************
    public function getTemas($foro, $inicio, $cantTemas) {

        $resultado = $this->mysqli->query("SELECT
            foro_temas.id_tema,
            foro_temas.id_foro,
            foro_temas.id_subforo,
            foro_temas.titulo,
            foro_temas.contenido,
            foro_temas.fecha,
            foro_temas.activo,
            foro_temas.hits,
            usuario.usu_nick as nick,
            foro_temas.id_usuario
            FROM
            foro_temas
            INNER JOIN usuario ON foro_temas.id_usuario = usuario.usu_cod
            where id_foro = $foro
            order by id_tema desc
            limit $inicio, $cantTemas");

        while ( $fila = $resultado->fetch_assoc() ) {
            $this->data[] = $fila;
        }
        
        return $this->data;
    }

    //*****************************************************************
    // TOTAL DE TEMAS DEL FORO
    //*****************************************************************
    public function TotalTemas($foro) {
        $resultado = $this->mysqli->query("select count(*) as total from foro_temas where id_foro = '$foro'"); 

        if ($reg = $resultado->fetch_array()) {
            $this->tTemas = $reg["total"];
        }

        return $this->tTemas;
    }
    //*****************************************************************
    // TOTAL TEMAS POR USUARIO
    //*****************************************************************
    public function TotalTemasUsuarios($id) {
        $resultado = $this->mysqli->query("select count(*) as total from foro_temas where id_usuario = '$id'"); 

        if ($reg = $resultado->fetch_array()) {
            $this->tTemas = $reg["total"];
        }

        return $this->tTemas;
    }

    //*****************************************************************
    // LISTAMOS LOS TEMAS PAGINADOS DEL SUBFORO
    //*****************************************************************
    public function getsubTemas($sub, $inicio, $cantTemas) {
        $resultado = $this->mysqli->query("SELECT
            foro_temas.id_tema,
            foro_temas.id_foro,
            foro_temas.id_subforo,
            foro_temas.titulo,
            foro_temas.contenido,
            foro_temas.fecha,
            foro_temas.activo,
            foro_temas.hits,
            usuario.usu_nick as nick,
            foro_temas.id_usuario
            FROM
            foro_temas
            INNER JOIN usuario ON foro_temas.id_usuario = usuario.usu_cod
            where id_subforo = $sub
            order by id_tema desc
            limit $inicio, $cantTemas");

        while ( $fila = $resultado->fetch_assoc() ) {
            $this->data[] = $fila;
        }
        
        return $this->data;
    }

    //*****************************************************************
    // TOTAL DE TEMAS DEL SUBFORO
    //*****************************************************************
    public function TotalsubTemas($sub) {
        $resultado = $this->mysqli->query("select count(*) as total from foro_temas where id_subforo = '$sub'"); 

        if ($reg = $resultado->fetch_array()) {
            $this->tTemas = $reg["total"];
        }

        return $this->tTemas;
    }

    //*****************************************************************
    // LISTAMOS LOS SUBFOROS POR FORO
    //*****************************************************************
    public function tema($id) {

        $resultado = $this->mysqli->query("SELECT
            foro_temas.id_tema,
            foro_temas.id_foro,
            foro_temas.id_subforo,
            foro_temas.titulo,
            foro_temas.contenido,
            foro_temas.fecha,
            foro_temas.activo,
            foro_temas.hits,
            usuario.usu_nick as nick,
            foro_temas.id_usuario
            FROM
            foro_temas
            INNER JOIN usuario ON foro_temas.id_usuario = usuario.usu_cod
            where id_tema = $id");

        while ( $fila = $resultado->fetch_assoc() ) {
            $this->data[] = $fila;
        }
        
        return $this->data;
    }

    //*****************************************************************
    // SUMA LAS VISITAS
    //*****************************************************************
    public function hits($id) {
        $resultado = $this->mysqli->query("UPDATE foro_temas SET hits = hits+1 WHERE id_tema = $id");
    }
    
    //*****************************************************************
    // LISTAMOS LOS SUBFOROS POR FORO
    //*****************************************************************
    public function buscar($buscar) {

        $resultado = $this->mysqli->query("SELECT
            foro_temas.id_tema,
            foro_temas.id_foro,
            foro_temas.id_subforo,
            foro_temas.titulo,
            foro_temas.contenido,
            foro_temas.fecha,
            foro_temas.id_usuario,
            foro_temas.activo,
            foro_temas.hits,
            usuario.usu_nick as nick
            FROM
            foro_temas
            INNER JOIN usuario ON foro_temas.id_usuario = usuario.usu_cod where titulo LIKE '%$buscar%'");

        while ( $fila = $resultado->fetch_assoc() ) {
            $this->data[] = $fila;
        }
        
        return $this->data;
    }
    
    //*****************************************************************
    // LISTAMOS LOS SUBFOROS POR FORO
    //*****************************************************************
    public function add($foro, $sub) {

        $tema = htmlentities($_POST['titulo']);
        $contenido = $_POST['contenido'];
        $usuario = $_SESSION['MM_Usercode'];
		$nombreusu=	$_SESSION['MM_Username'];
        $activo = 1;
        $hit = 0;
        $resultado = $this->mysqli->query("INSERT INTO foro_temas(id_foro, id_subforo, titulo, contenido, fecha, id_usuario, activo, hits) 
            VALUES($foro, $sub, '$tema', '$contenido', now(), $usuario, $activo, $hit)"); 
			// Eleccion de categoria
		$resultado = $this->mysqli->query("select id_foro, foro from foro_foro WHERE id_foro=$foro");
     	$fila = $resultado->fetch_assoc();
        // envio de e-mail de creación		
		$para  = 'Alfredo Vega<alfredo.vega@gruposeguro.net>' . ', '; // atención a la coma
		$para .= 'Alexandra Zafra<alexandra.zafra@gruposeguro.net>'. ', ';
		$usuarios = $this->mysqli->query("SELECT usu_email as correo FROM usuario where usu_estado=0 and usu_cod between '58' and '62'");
		while( $datosusu = $usuarios->fetch_assoc() ){
            $para.= $datosusu['correo'];
			$para.= ',';
        }
        //$para .= 'Subagencias <agenciassubmx@marcimex.com.ec>';
		// título
		$título = 'FORO VEGAMON S.A. CREACION DE NUEVO TEMA ';
		// mensaje
		$mensaje = '
		<html>
		<head>
		  <title>FORO VEGAMON S.A. - NOTIFICACION DE NUEVO TEMA</title>
		</head>
		<body>
		  <p>Revisar nuevo tema creado dentro de nuestro sistema, con el titulo <b><big>'. $tema. '</b></big> dentro del foro <b><big>'.$fila["foro"].'</b></big>. Para cualquier inquietud por favor crear un comentario dentro del mismo</p>
		  <br>
		  <br>
		  <p><b>POR FAVOR NO RESPONDER ESTE MENSAJE AUTOMATICO. GRACIAS</b></p>
		  <br>
		  <br>
		  <p><b>Atentamente</b></p>
		  <br>
		  <p><b><big>'.$nombreusu.'</p></big></b>
		</body>
		</html>
		';
		// Para enviar un correo HTML, debe establecerse la cabecera Content-type
		$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
		$cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		// Cabeceras adicionales
		//$cabeceras .= 'To: psuarez@marcimex.com.ec , gtorres@marcimex.com.ec' . "\r\n";
		$cabeceras .= 'From: Alexandra Zafra<alexandra.zafra@gruposeguro.net>' . "\r\n";
		//$cabeceras .= 'Cc: Paola Illescas <pillescas@marcimex.com.ec>' . "\r\n";
		//$cabeceras .= 'Bcc: Alfredo Vega <alfredo.vega@gruposeguro.net>' . "\r\n";
		// Enviarlo
		mail($para, $título, $mensaje, $cabeceras);
        if($sub == 0){
            echo "<script type='text/javascript'>window.location='temas.php?foro=$foro';</script>";
        }else{
            echo "<script type='text/javascript'>window.location='temas.php?foro=$foro&sub=$sub';</script>";
        }
    }
    //*****************************************************************
    // LISTAMOS LOS SUBFOROS POR FORO
    //*****************************************************************
    public function del($id, $foro, $sub) {
        $resultado = $this->mysqli->query("DELETE FROM foro_temas WHERE id_tema = $id");
        if($sub == 0){
            echo "<script type='text/javascript'>window.location='temas.php?foro=$foro';</script>";
        }else{
            echo "<script type='text/javascript'>window.location='temas.php?foro=$foro&sub=$sub';</script>";
        }
    }
}
?>