// JavaScript Document
console.log("Hola");

//Cargamos los datos desde la ApiREST

d3.json("../../RestAPI/read.php").then(function(datosCompletos){
	console.log("Datos Cargados");
	window.datos=datosCompletos;
	
	//Decalracion de variables para el área del gráfico 
	
	var height=500;
	var width=500;
	var margin={
		
		top:20,
		bottom:50,
		left:25,
		right:50
	};
	
	var ElementoSVG = d3.select("body")
		.append("svg")
		.attr("height",height)
		.attr("width",width)

	var textitulo = ElementoSVG.selectAll("textitulo").data([0])
	    .enter()
		.append("text")
		.text("Polizas por rango")
		.attr("x",margin.left)
		.attr("y",margin.top)
	
	var escalaX=d3.scaleLinear()
		.domain(d3.extent(datos,d => d.num))
	    //.domain([0,datos.length])
	    //.domain([1,100])
		.range([0+margin.left,width - margin.right])
	var ejeX=d3.axisBottom(escalaX)
		//.tickFormat(d3.format(".2s"))
	
	ElementoSVG
		.append("g")
		.attr("transform","translate(350,"+(height-margin.bottom)+")")
		.call(ejeX)
	
	var escalaY=d3.scaleLinear()
		.domain(d3.extent(datos,d=>d.com))
		.range([height-margin.bottom,0+ margin.top])
	var ejeY=d3.axisLeft(escalaY)
	  //	.tickFormat(d3.format(".3s"))
		
	ElementoSVG
		.append("g")
		.attr("transform","translate("+(margin.left+8)+",0)")
		.call(ejeY)
	
	var EscalaTamanio = d3.scaleLinear()
		.domain(d3.extent(datos,d=>d.com))
		.range([5,20])
	var EscalaColor = d3.scaleLinear()
		.domain(d3.extent(datos,d=>d.pol_cod_agente))
		.range(["orange","green"]);
	
	ElementoSVG
		.selectAll("circle")
		.data(datos)
		.enter()
		.append("circle")
		.attr("r",d=>EscalaTamanio(d.com))
		.attr("cx",d=>escalaX(d.num))
		.attr("cy",d=>escalaY(d.com))
		.attr("fill",d=>EscalaColor(d.pol_cod_agente))
		.append("g");

	var ul=d3.select("body")
		.append("ul")
		.selectAll("li")
		.data(datos)
		.enter()
		.append("li")
		.html(String)
		.text(function(d){return d.Agente;})
		.style("font-size","10pt")
		.style("color",d=>EscalaColor(d.pol_cod_agente))
		
	
});




