<?php 
if (!isset($_SESSION)) {
  session_start();
}
$MM_authorizedUsers = "";
$MM_donotCheckaccess = "true";

// *** Restrict Access To Page: Grant or deny access to this page
function isAuthorized($strUsers, $strGroups, $UserName, $UserGroup) { 
  // For security, start by assuming the visitor is NOT authorized. 
  $isValid = False; 

  // When a visitor has logged into this site, the Session variable MM_Username set equal to their username. 
  // Therefore, we know that a user is NOT logged in if that Session variable is blank. 
  if (!empty($UserName)) { 
    // Besides being logged in, you may restrict access to only certain users based on an ID established when they login. 
    // Parse the strings into arrays. 
    $arrUsers = Explode(",", $strUsers); 
    $arrGroups = Explode(",", $strGroups); 
    if (in_array($UserName, $arrUsers)) { 
      $isValid = true; 
    } 
    // Or, you may restrict access to only certain users based on their username. 
    if (in_array($UserGroup, $arrGroups)) { 
      $isValid = true; 
    } 
    if (($strUsers == "") && true) { 
      $isValid = true; 
    } 
  } 
  return $isValid; 
}

$MM_restrictGoTo = "error.html";
if (!((isset($_SESSION['MM_Username'])) && (isAuthorized("",$MM_authorizedUsers, $_SESSION['MM_Username'], $_SESSION['MM_UserGroup'])))) {   
  $MM_qsChar = "?";
  $MM_referrer = $_SERVER['PHP_SELF'];
  if (strpos($MM_restrictGoTo, "?")) $MM_qsChar = "&";
  if (isset($_SERVER['QUERY_STRING']) && strlen($_SERVER['QUERY_STRING']) > 0) 
  $MM_referrer .= "?" . $_SERVER['QUERY_STRING'];
  $MM_restrictGoTo = $MM_restrictGoTo. $MM_qsChar . "accesscheck=" . urlencode($MM_referrer);
  header("Location: ". $MM_restrictGoTo); 
  exit;
}
?>
<?php require_once('../../Connections/conexion.php'); ?>
<?php include('../../main/libreria.php');?>
<?php
include('../../main/funciones.php');
if (!function_exists("GetSQLValueString")) {
function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") 
{
  if (PHP_VERSION < 6) {
    $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
  }

  $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

  switch ($theType) {
    case "text":
      $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
      break;    
    case "long":
    case "int":
      $theValue = ($theValue != "") ? intval($theValue) : "NULL";
      break;
    case "double":
      $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
      break;
    case "date":
      $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
      break;
    case "defined":
      $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
      break;
  }
  return $theValue;
}
}

 ?>




<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
<title>Frontier JQuery Calendar</title>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js"></script>

 <link href="../../libest/estilos.php" rel="stylesheet" type="text/css" /><!-- Include CSS for JQuery Frontier Calendar plugin (Required for calendar plugin) -->
<link rel="stylesheet" type="text/css" href="css/frontierCalendar/jquery-frontier-cal-1.3.2.css" />

<!-- Include CSS for color picker plugin (Not required for calendar plugin. Used for example.) -->
<link rel="stylesheet" type="text/css" href="css/colorpicker/colorpicker.css" />

<!-- Include CSS for JQuery UI (Required for calendar plugin.) -->
<link rel="stylesheet" type="text/css" href="css/jquery-ui/smoothness/jquery-ui-1.8.1.custom.css" />

<!--
Include JQuery Core (Required for calendar plugin)
** This is our IE fix version which enables drag-and-drop to work correctly in IE. See README file in js/jquery-core folder. **
-->
<script type="text/javascript" src="js/jquery-core/jquery-1.4.2-ie-fix.min.js"></script>

<!-- Include JQuery UI (Required for calendar plugin.) -->
<script type="text/javascript" src="js/jquery-ui/smoothness/jquery-ui-1.8.1.custom.min.js"></script>

<!-- Include color picker plugin (Not required for calendar plugin. Used for example.) -->
<script type="text/javascript" src="js/colorpicker/colorpicker.js"></script>

<!-- Include jquery tooltip plugin (Not required for calendar plugin. Used for example.) -->
<script type="text/javascript" src="js/jquery-qtip-1.0.0-rc3140944/jquery.qtip-1.0.js"></script>


<!--
	(Required for plugin)
	Dependancies for JQuery Frontier Calendar plugin.
    ** THESE MUST BE INCLUDED BEFORE THE FRONTIER CALENDAR PLUGIN. **
-->
<script type="text/javascript" src="js/lib/jshashtable-2.1.js"></script>

<!-- Include JQuery Frontier Calendar plugin -->
<script type="text/javascript" src="js/frontierCalendar/jquery-frontier-cal-1.3.2.min.js"></script>


</head>
<body  bgcolor="<?php echo parametros($database_conexion, $conexion, 'color_fondo'); ?>" >
<script type="text/javascript" >

</script>
<form name="from2" >
<div id="resultado1"></div>	
</form>
<!-- Some CSS for our example. (Not required for calendar plugin. Used for example.)-->
<style type="text/css" media="screen">
/*
Default font-size on the default ThemeRoller theme is set in ems, and with a value that when combined 
with body { font-size: 62.5%; } will align pixels with ems, so 11px=1.1em, 14px=1.4em. If setting the 
body font-size to 62.5% isn't an option, or not one you want, you can set the font-size in ThemeRoller 
to 1em or set it to px.
http://osdir.com/ml/jquery-ui/2009-04/msg00071.html
*/
body { font-size: 62.5%; }
.shadow {
	-moz-box-shadow: 3px 3px 4px #aaaaaa;
	-webkit-box-shadow: 3px 3px 4px #aaaaaa;
	box-shadow: 3px 3px 4px #aaaaaa;
	/* For IE 8 */
	-ms-filter: "progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=135, Color='#aaaaaa')";
	/* For IE 5.5 - 7 */
	filter: progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=135, Color='#aaaaaa');
}
</style>
<!-- Some CSS for our example. (Not required for calendar plugin. Used for example.)-->
<script type="text/javascript">

	function objetoAjax(){
			var xmlhttp=false;
			try {
					xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
			} catch (e) {
					try {
					   xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
					} catch (E) {
							xmlhttp = false;
					}
			}
	
			if (!xmlhttp && typeof XMLHttpRequest!='undefined') {
					xmlhttp = new XMLHttpRequest();
			}
			return xmlhttp;
	}


$(document).ready(function(){	


	var clickDate = "";
	var clickAgendaItem = "";
	
	/**
	 * Initializes calendar with current year & month
	 * specifies the callbacks for day click & agenda item click events
	 * then returns instance of plugin object
	 */
	var jfcalplugin = $("#mycal").jFrontierCal({
		date: new Date(),
		dayClickCallback: myDayClickHandler,
		agendaClickCallback: myAgendaClickHandler,
		agendaDropCallback: myAgendaDropHandler,
		agendaMouseoverCallback: myAgendaMouseoverHandler,
		applyAgendaTooltipCallback: myApplyTooltip,
		agendaDragStartCallback : myAgendaDragStart,
		agendaDragStopCallback : myAgendaDragStop,
		dragAndDropEnabled: true
	}).data("plugin");
	
	/**
	 * Do something when dragging starts on agenda div
	 */
	function myAgendaDragStart(eventObj,divElm,agendaItem){
		// destroy our qtip tooltip
		if(divElm.data("qtip")){
			divElm.qtip("destroy");
		}	
	};
	
	/**
	 * Do something when dragging stops on agenda div
	 */
	function myAgendaDragStop(eventObj,divElm,agendaItem){
		//alert("drag stop");
	};
	
	/**
	 * Custom tooltip - use any tooltip library you want to display the agenda data.
	 * for this example we use qTip - http://craigsworks.com/projects/qtip/
	 *
	 * @param divElm - jquery object for agenda div element
	 * @param agendaItem - javascript object containing agenda data.
	 */
	function myApplyTooltip(divElm,agendaItem){

		// Destroy currrent tooltip if present
		if(divElm.data("qtip")){
			divElm.qtip("destroy");
		}
		
		var displayData = "";
		
		var title = agendaItem.title;
		var startDate = agendaItem.startDate;
		var endDate = agendaItem.endDate;
		var allDay = agendaItem.allDay;
		var data = agendaItem.data;
		displayData += "<br><b>" + title+ "</b><br><br>";
		if(allDay){
			displayData += "(Todos los eventos del dia)<br><br>";
		}else{
			displayData += "<b>Iniciada el:</b> " + startDate + "<br>" + "<b>Finalizar el:</b> " + endDate + "<br><br>";
		}
		for (var propertyName in data) {
			displayData += "<b>" + propertyName + ":</b> " + data[propertyName] + "<br>"
		}
		// use the user specified colors from the agenda item.
		var backgroundColor = agendaItem.displayProp.backgroundColor;
		var foregroundColor = agendaItem.displayProp.foregroundColor;
		var myStyle = {
			border: {
				width: 5,
				radius: 10
			},
			padding: 10, 
			textAlign: "left",
			tip: true,
			name: "dark" // other style properties are inherited from dark theme		
		};
		if(backgroundColor != null && backgroundColor != ""){
			myStyle["backgroundColor"] = backgroundColor;
		}
		if(foregroundColor != null && foregroundColor != ""){
			myStyle["color"] = foregroundColor;
		}
		// apply tooltip
		divElm.qtip({
			content: displayData,
			position: {
				corner: {
					tooltip: "bottomMiddle",
					target: "topMiddle"			
				},
				adjust: { 
					mouse: true,
					x: 0,
					y: -15
				},
				target: "mouse"
			},
			show: { 
				when: { 
					event: 'mouseover'
				}
			},
			style: myStyle
		});

	};

	/**
	 * Make the day cells roughly 3/4th as tall as they are wide. this makes our calendar wider than it is tall. 
	 */
	jfcalplugin.setAspectRatio("#mycal",0.75);

	/**
	 * Called when user clicks day cell
	 * use reference to plugin object to add agenda item
	 */
	function myDayClickHandler(eventObj){
		// Get the Date of the day that was clicked from the event object
		var date = eventObj.data.calDayDate;
		// store date in our global js variable for access later
		clickDate = date.getFullYear() + "-" + (date.getMonth()+1) + "-" + date.getDate();
		// open our add event dialog
		$('#add-event-form').dialog('open');
	};
	
	/**
	 * Called when user clicks and agenda item
	 * use reference to plugin object to edit agenda item
	 */
	function myAgendaClickHandler(eventObj){
		// Get ID of the agenda item from the event object
		var agendaId = eventObj.data.agendaId;		
		// pull agenda item from calendar
		var agendaItem = jfcalplugin.getAgendaItemById("#mycal",agendaId);
		clickAgendaItem = agendaItem;
		$("#display-event-form").dialog('open');
	};
	
	/**
	 * Called when user drops an agenda item into a day cell.
	 */
	function myAgendaDropHandler(eventObj){
		// Get ID of the agenda item from the event object
		var agendaId = eventObj.data.agendaId;
		// date agenda item was dropped onto
		var date = eventObj.data.calDayDate;
		// Pull agenda item from calendar
		var agendaItem = jfcalplugin.getAgendaItemById("#mycal",agendaId);		
//		alert("You dropped agenda item " + agendaItem.title +  			" onto " + date.toString() + ". Here is where you can make an AJAX call to update your database.");
	};
	
	/**
	 * Called when a user mouses over an agenda item	
	 */
	function myAgendaMouseoverHandler(eventObj){
		var agendaId = eventObj.data.agendaId;
		var agendaItem = jfcalplugin.getAgendaItemById("#mycal",agendaId);
		//alert("You moused over agenda item " + agendaItem.title + " at location (X=" + eventObj.pageX + ", Y=" + eventObj.pageY + ")");
	};
	/**
	 * Initialize jquery ui datepicker. set date format to yyyy-mm-dd for easy parsing
	 */
	$("#dateSelect").datepicker({
		showOtherMonths: true,
		selectOtherMonths: true,
		changeMonth: true,
		changeYear: true,
		showButtonPanel: true,
		dateFormat: 'yy-mm-dd'
	});
	
	/**
	 * Set datepicker to current date
	 */
	$("#dateSelect").datepicker('setDate', new Date());
	/**
	 * Use reference to plugin object to a specific year/month
	 */
	$("#dateSelect").bind('change', function() {
		var selectedDate = $("#dateSelect").val();
		var dtArray = selectedDate.split("-");
		var year = dtArray[0];
		// jquery datepicker months start at 1 (1=January)		
		var month = dtArray[1];
		// strip any preceeding 0's		
		month = month.replace(/^[0]+/g,"")		
		var day = dtArray[2];
		// plugin uses 0-based months so we subtrac 1
		jfcalplugin.showMonth("#mycal",year,parseInt(month-1).toString());
	});	
	/**
	 * Initialize previous month button
	 */
	$("#BtnPreviousMonth").button();
	$("#BtnPreviousMonth").click(function() {
		jfcalplugin.showPreviousMonth("#mycal");
		// update the jqeury datepicker value
		var calDate = jfcalplugin.getCurrentDate("#mycal"); // returns Date object
		var cyear = calDate.getFullYear();
		// Date month 0-based (0=January)
		var cmonth = calDate.getMonth();
		var cday = calDate.getDate();
		// jquery datepicker month starts at 1 (1=January) so we add 1
		$("#dateSelect").datepicker("setDate",cyear+"-"+(cmonth+1)+"-"+cday);
		return false;
	});
	/**
	 * Initialize next month button
	 */
	$("#BtnNextMonth").button();
	$("#BtnNextMonth").click(function() {
		jfcalplugin.showNextMonth("#mycal");
		// update the jqeury datepicker value
		var calDate = jfcalplugin.getCurrentDate("#mycal"); // returns Date object
		var cyear = calDate.getFullYear();
		// Date month 0-based (0=January)
		var cmonth = calDate.getMonth();
		var cday = calDate.getDate();
		// jquery datepicker month starts at 1 (1=January) so we add 1
		$("#dateSelect").datepicker("setDate",cyear+"-"+(cmonth+1)+"-"+cday);		
		return false;
	});
	
	/**
	 * Initialize delete all agenda items button
	 */
	$("#BtnDeleteAll").button();
	$("#BtnDeleteAll").click(function() {	
		jfcalplugin.deleteAllAgendaItems("#mycal");	
		return false;
	});		
	
	
	
	$("#CargarDatos").button();
	$("#CargarDatos").click(function() 
		{	
			jfcalplugin.deleteAllAgendaItems("#mycal");	
			usuario=document.form1.usuario.value; //usuario
			
			var xmlhttp;
			if( window.XMLHttpRequest )
				{
					xmlhttp = new XMLHttpRequest();
				}
			else if(window.ActiveXObject) 
			{
				xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
			}
			else
				{return false;}
			xmlhttp.open('GET', "select_calendario.php?usuario="+usuario);
			xmlhttp.onreadystatechange = function()
			{
				if( xmlhttp.readyState == 4 && xmlhttp.status == 200 )
				{  
				var cadena= new Array();
				//alert(xmlhttp.responseText);
					var r = xmlhttp.responseText,
					
					//Convertimos la cadena a JSON
					cadena =JSON.parse(r),
					ul = document.createElement( 'ul' );
					if( cadena.length )
					{
						for( var i in cadena )
						{
							var li = document.createElement('li');
							li.innerHTML = cadena[i];
							ul.appendChild(li);
							
							var hora_inicial=cadena[i][2];
							var hora_final=cadena[i][3];
							
							var elem_ini = hora_inicial.split(':');
					
							var elem_ini1= elem_ini[1].split(' ');
							
							var hora_ini = elem_ini[0];
							var minu_ini=elem_ini1[0];
							var meridiano_ini=elem_ini1[1];
							
							var elem_fin = hora_final.split(':');
					
							var elem_finn = elem_fin[1].split(' ');
							
							var hora_fin = elem_fin[0];
							var minu_fin= elem_finn[0];
							var meridiano_fin=elem_finn[1];
							
							var what = jQuery.trim(cadena[i][4]);	
							var startDate = cadena[i][0];
							var startDtArray = startDate.split("-");
							var startYear = startDtArray[0];
							var startMonth = startDtArray[1];		
							var startDay = startDtArray[2];
							startMonth = startMonth.replace(/^[0]+/g,"");
							startDay = startDay.replace(/^[0]+/g,"");
							var startHour = jQuery.trim(hora_ini);
							var startMin = jQuery.trim(minu_ini);
							var startMeridiem = jQuery.trim(meridiano_ini);
							startHour = parseInt(startHour.replace(/^[0]+/g,""));
							if(startMin == "0" || startMin == "00")
							{
								startMin = 0;
							}else
							{
								startMin = parseInt(startMin.replace(/^[0]+/g,""));
							}
							if(startMeridiem == "AM" && startHour == 12)
							{
								startHour = 0;
							}
							else if(startMeridiem == "PM" && startHour < 12)
							{
								startHour = parseInt(startHour) + 12;
							}
							
							var endDate = cadena[i][1];
							var endDtArray = endDate.split("-");
							var endYear = endDtArray[0];
							var endMonth = endDtArray[1];		
							var endDay = endDtArray[2];
							endMonth = endMonth.replace(/^[0]+/g,"");
							endDay = endDay.replace(/^[0]+/g,"");
							var endHour = jQuery.trim(hora_fin);
							var endMin = jQuery.trim(minu_fin);
							var endMeridiem = jQuery.trim(meridiano_fin);
							endHour = parseInt(endHour.replace(/^[0]+/g,""));
							if(endMin == "0" || endMin == "00")
							{
								endMin = 0;
							}else{
								endMin = parseInt(endMin.replace(/^[0]+/g,""));
							}
							if(endMeridiem == "AM" && endHour == 12)
							{
								endHour = 0;
							}else if(endMeridiem == "PM" && endHour < 12)
							{
								endHour = parseInt(endHour) + 12;
							}
							var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
							var dias= new Array ("Lun","Mar","Mie","Jue", "Vie","Sab", "Dom");

							var startDateObj = new Date(parseInt(startYear),parseInt(startMonth)-1,parseInt(startDay),startHour,startMin);
							var endDateObj = new Date(parseInt(endYear),parseInt(endMonth)-1,parseInt(endDay),endHour,endMin);
							
							jfcalplugin.addAgendaItem
							(
								"#mycal",
								what,
								startDateObj,
								endDateObj,
								false,
								{
									
									Usuario:document.form1.usuario.value,          
									Fecha_de_Ingreso: cadena[i][7],
									
								},
								{
									backgroundColor: cadena[i][5],
									foregroundColor: cadena[i][6]
								}
							);
						}
					}
				}
			}
			xmlhttp.send( null );
			
		});
	
	
	
	
	
	/**
	 * Initialize iCal test button
	 */
	$("#BtnICalTest").button();
	$("#BtnICalTest").click(function() {
		// Please note that in Google Chrome this will not work with a local file. Chrome prevents AJAX calls
		// from reading local files on disk.		
		jfcalplugin.loadICalSource("#mycal",$("#iCalSource").val(),"html");	
		return false;
	});	

	/**
	 * Initialize add event modal form
	 */
	$("#add-event-form").dialog({
		autoOpen: false,
		height: 400,
		width: 400,
		modal: true,
		buttons: {
			'Nuevo Evento1': function() {

				var evento = (jQuery.trim($("#what").val())).split(")");
				var what = evento[1];
				var cod_tarea=(evento[0]).split("(");
				cod_tarea=cod_tarea[1];
			
				if(!evento[1]){
					alert("Por favor escoja una tarea");
				}else
				{
				
					var startDate = $("#startDate").val();
					var startDtArray = startDate.split("-");
					var startYear = startDtArray[0];
					// jquery datepicker months start at 1 (1=January)		
					var startMonth = startDtArray[1];		
					var startDay = startDtArray[2];
					// strip any preceeding 0's		
					startMonth = startMonth.replace(/^[0]+/g,"");
					startDay = startDay.replace(/^[0]+/g,"");
					var startHour = jQuery.trim($("#startHour").val());
					var startMin = jQuery.trim($("#startMin").val());
					var startMeridiem = jQuery.trim($("#startMeridiem").val());
					startHour = parseInt(startHour.replace(/^[0]+/g,""));
					if(startMin == "0" || startMin == "00"){
						startMin = 0;
					}else{
						startMin = parseInt(startMin.replace(/^[0]+/g,""));
					}
					if(startMeridiem == "AM" && startHour == 12){
						startHour = 0;
					}else if(startMeridiem == "PM" && startHour < 12){
						startHour = parseInt(startHour) + 12;
					}

					var endDate = $("#endDate").val();
					var endDtArray = endDate.split("-");
					var endYear = endDtArray[0];
					// jquery datepicker months start at 1 (1=January)		
					var endMonth = endDtArray[1];		
					var endDay = endDtArray[2];
					// strip any preceeding 0's		
					endMonth = endMonth.replace(/^[0]+/g,"");

					endDay = endDay.replace(/^[0]+/g,"");
					var endHour = jQuery.trim($("#endHour").val());
					var endMin = jQuery.trim($("#endMin").val());
					var endMeridiem = jQuery.trim($("#endMeridiem").val());
					endHour = parseInt(endHour.replace(/^[0]+/g,""));
					if(endMin == "0" || endMin == "00"){
						endMin = 0;
					}else{
						endMin = parseInt(endMin.replace(/^[0]+/g,""));
					}
					if(endMeridiem == "AM" && endHour == 12){
						endHour = 0;
					}else if(endMeridiem == "PM" && endHour < 12){
						endHour = parseInt(endHour) + 12;
					}
					
					//alert("Start time: " + startHour + ":" + startMin + " " + startMeridiem + ", End time: " + endHour + ":" + endMin + " " + endMeridiem);

					// Dates use integers
					var startDateObj = new Date(parseInt(startYear),parseInt(startMonth)-1,parseInt(startDay),startHour,startMin,0,0);
					var endDateObj = new Date(parseInt(endYear),parseInt(endMonth)-1,parseInt(endDay),endHour,endMin,0,0);

					// add new event to the calendar
					jfcalplugin.addAgendaItem(
						"#mycal",
						what,
						startDateObj,
						endDateObj,
						false,
						{
							Usuario:document.form1.usuario.value,          
							Fecha_de_Ingreso: new Date(),
						},
						{
							backgroundColor: $("#colorBackground").val(),
							foregroundColor: $("#colorForeground").val()
						}
					);
					
					divResultado = document.getElementById('resultado');
					fecha_inicialm=document.form1.startDate.value; //fecha inical
					fecha_finalm=document.form1.endDate.value; //fecha final
					hora_inicalm=document.form1.startHour.value; //hora inical
					hora_finalm=document.form1.endHour.value; //hora final
					minuto_inicalm=document.form1.startMin.value; //minuto inical
					minuto_finalm=document.form1.endMin.value; //minuto final
					am_pm_inicalm=document.form1.startMeridiem.value; //am_pm inical
					am_pm_finalm=document.form1.endMeridiem.value; //am_pm final
					eventom=what; //nombre del evento
					color_Backgroundm=document.form1.colorBackground.value; //color_background
					color_Backgroundm=color_Backgroundm.replace('#','');
					color_textm=document.form1.colorForeground.value; //color_text
					color_textm=color_textm.replace('#','');
					
					ajax=objetoAjax();
					ajax.open("GET", "insert_calendario.php?fecha_inicialm="+fecha_inicialm+"&fecha_finalm="+fecha_finalm+"&hora_inicalm="+hora_inicalm+"&hora_finalm="+hora_finalm+"&minuto_inicalm="+minuto_inicalm+"&minuto_finalm="+minuto_finalm+"&am_pm_inicalm="+am_pm_inicalm+"&am_pm_finalm="+am_pm_finalm+"&eventom="+eventom+"&color_Backgroundm="+color_Backgroundm+"&color_textm="+color_textm+"&cod_tarea="+cod_tarea);
					ajax.onreadystatechange=function() 
					{
						if (ajax.readyState==4) 
						{				
							$("#add-event-form").load('calendar.php #add-event-form');
							//alert('22');
							//alert(ajax.responseText);
							divResultado1.innerHTML = ajax.responseText;
							
						}
					}
					            ajax.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
					ajax.send(null);
				}
				document.getElementById('what').options[0]=new Option("Tareas","12","selected");
				$(this).dialog('close');
				
			},
			
			'Editar': function() {
				
				
				
					jfcalplugin.deleteAgendaItemById("#mycal",clickAgendaItem.agendaId);
					var id=clickAgendaItem.agendaId;
					var what = jQuery.trim($("#what").val());
					var startDate = $("#startDate").val();
					var startDtArray = startDate.split("-");
					var startYear = startDtArray[0];
					// jquery datepicker months start at 1 (1=January)		
					var startMonth = startDtArray[1];		
					var startDay = startDtArray[2];
					// strip any preceeding 0's		
					startMonth = startMonth.replace(/^[0]+/g,"");
					startDay = startDay.replace(/^[0]+/g,"");
					var startHour = jQuery.trim($("#startHour").val());
					var startMin = jQuery.trim($("#startMin").val());
					var startMeridiem = jQuery.trim($("#startMeridiem").val());
					startHour = parseInt(startHour.replace(/^[0]+/g,""));
					if(startMin == "0" || startMin == "00"){
						startMin = 0;
					}else{
						startMin = parseInt(startMin.replace(/^[0]+/g,""));
					}
					if(startMeridiem == "AM" && startHour == 12){
						startHour = 0;
					}else if(startMeridiem == "PM" && startHour < 12){
						startHour = parseInt(startHour) + 12;
					}

					var endDate = $("#endDate").val();
					var endDtArray = endDate.split("-");
					var endYear = endDtArray[0];
					// jquery datepicker months start at 1 (1=January)		
					var endMonth = endDtArray[1];		
					var endDay = endDtArray[2];
					// strip any preceeding 0's		
					endMonth = endMonth.replace(/^[0]+/g,"");

					endDay = endDay.replace(/^[0]+/g,"");
					var endHour = jQuery.trim($("#endHour").val());
					var endMin = jQuery.trim($("#endMin").val());
					var endMeridiem = jQuery.trim($("#endMeridiem").val());
					endHour = parseInt(endHour.replace(/^[0]+/g,""));
					if(endMin == "0" || endMin == "00"){
						endMin = 0;
					}else{
						endMin = parseInt(endMin.replace(/^[0]+/g,""));
					}
					if(endMeridiem == "AM" && endHour == 12){
						endHour = 0;
					}else if(endMeridiem == "PM" && endHour < 12){
						endHour = parseInt(endHour) + 12;
					}
					
					//alert("Start time: " + startHour + ":" + startMin + " " + startMeridiem + ", End time: " + endHour + ":" + endMin + " " + endMeridiem);

					// Dates use integers
					var startDateObj = new Date(parseInt(startYear),parseInt(startMonth)-1,parseInt(startDay),startHour,startMin,0,0);
					var endDateObj = new Date(parseInt(endYear),parseInt(endMonth)-1,parseInt(endDay),endHour,endMin,0,0);

					// add new event to the calendar
					jfcalplugin.addAgendaItem(
						"#mycal",
						what,
						startDateObj,
						endDateObj,
						false,
						{
							Usuario:document.form1.usuario.value,          
							Fecha_de_Ingreso: new Date(),
						},
						{
							backgroundColor: $("#colorBackground").val(),
							foregroundColor: $("#colorForeground").val()
						}
					);
					
					divResultado = document.getElementById('resultado');
					fecha_inicialm=document.form1.startDate.value; //fecha inical
					fecha_finalm=document.form1.endDate.value; //fecha final
					hora_inicalm=document.form1.startHour.value; //hora inical
					//alert(hora_inicalm);
					hora_finalm=document.form1.endHour.value; //hora final				
					//alert(hora_finalm);
					minuto_inicalm=document.form1.startMin.value; //minuto inical
					minuto_finalm=document.form1.endMin.value; //minuto final
					am_pm_inicalm=document.form1.startMeridiem.value; //am_pm inical
					am_pm_finalm=document.form1.endMeridiem.value; //am_pm final
					eventom=document.form1.what.value; //nombre del evento
					color_Backgroundm=document.form1.colorBackground.value; //color_background
					color_Backgroundm=color_Backgroundm.replace('#','');
					color_textm=document.form1.colorForeground.value; //color_text
					color_textm=color_textm.replace('#','');
					
					ajax=objetoAjax();
					//alert(fecha_inicialm+" "+hora_inicalm+"  "+hora_finalm+"  "+minuto_inicalm);
				ajax.open("GET", "update_calendario.php?fecha_inicialm="+fecha_inicialm+"&fecha_finalm="+fecha_finalm+"&hora_inicalm="+hora_inicalm+"&hora_finalm="+hora_finalm+"&minuto_inicalm="+minuto_inicalm+"&minuto_finalm="+minuto_finalm+"&am_pm_inicalm="+am_pm_inicalm+"&am_pm_finalm="+am_pm_finalm+"&eventom="+eventom+"&color_Backgroundm="+color_Backgroundm+"&color_textm="+color_textm+"&id="+id);
					ajax.onreadystatechange=function() 
					{
						if (ajax.readyState==4) 
						{
							$("#add-event-form").dialog('close');
							divResultado1.innerHTML = ajax.responseText;	
						}
					}
					            ajax.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
					ajax.send(null);
			},		
			Cancelar: function() {

				$(this).dialog('close');
			}
		},
		open: function(event, ui){
			// initialize start date picker
			$("#startDate").datepicker({
				showOtherMonths: true,
				selectOtherMonths: true,
				changeMonth: true,
				changeYear: true,
				showButtonPanel: true,
				dateFormat: 'yy-mm-dd'
			});
			// initialize end date picker
			$("#endDate").datepicker({
				showOtherMonths: true,
				selectOtherMonths: true,
				changeMonth: true,
				changeYear: true,
				showButtonPanel: true,
				dateFormat: 'yy-mm-dd'
			});
			// initialize with the date that was clicked
			if ((clickDate) != "")
			{
				$("#startDate").val(clickDate);
				$("#endDate").val(clickDate);
				clickDate=""
			}
			// initialize color pickers
			$("#colorSelectorBackground").ColorPicker({
				color: "#555555",
				onShow: function (colpkr) {
					$(colpkr).css("z-index","10000");
					$(colpkr).fadeIn(500);
					return false;
				},
				onHide: function (colpkr) {
					$(colpkr).fadeOut(500);
					return false;
				},
				onChange: function (hsb, hex, rgb) {
					$("#colorSelectorBackground div").css("backgroundColor", "#" + hex);
					$("#colorBackground").val("#" + hex);
				}
			});
			//$("#colorBackground").val("#1040b0");		
			$("#colorSelectorForeground").ColorPicker({
				color: "#ffffff",
				onShow: function (colpkr) {
					$(colpkr).css("z-index","10000");
					$(colpkr).fadeIn(500);
					return false;
				},
				onHide: function (colpkr) {
					$(colpkr).fadeOut(500);
					return false;
				},
				onChange: function (hsb, hex, rgb) {
					$("#colorSelectorForeground div").css("backgroundColor", "#" + hex);
					$("#colorForeground").val("#" + hex);
				}
			});
			//$("#colorForeground").val("#ffffff");				
			// put focus on first form input element
			$("#what").focus();
		},
		
		close: function() {
				$("#startDate").datepicker("destroy");
				$("#endDate").datepicker("destroy");
				$("#startDate").val("");
				$("#endDate").val("");
				$("#startHour option:eq(0)").attr("selected", "selected");
				$("#startMin option:eq(0)").attr("selected", "selected");
				$("#startMeridiem option:eq(0)").attr("selected", "selected");
				$("#endHour option:eq(0)").attr("selected", "selected");
				$("#endMin option:eq(0)").attr("selected", "selected");
				$("#endMeridiem option:eq(0)").attr("selected", "selected");			
				$("#what option:eq(0)").attr("selected", "selected");		
		}
		
	});
	
	/**
	 * Initialize display event form.
	 */
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//menu al oprimir sobre una tarea
	$("#display-event-form").dialog({
		autoOpen: false,
		height: 400,
		width: 400,
		modal: true,
		buttons: {		
			Cancelar: function() {
				$(this).dialog('close');
			},
			//
			Modificar : function() {
				var title = clickAgendaItem.title;
				var id_mod = clickAgendaItem.agendaId;
				$(this).dialog('close');
				usuario=document.form1.usuario.value; //usuario
				var xmlhttp;
				if( window.XMLHttpRequest )
					{
						xmlhttp = new XMLHttpRequest();
					}
				else if(window.ActiveXObject) 
				{
					xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
				}
				else
					{return false;}
					//alert("select_consulta.php?usuario="+usuario+"&id_mod="+id_mod);
				xmlhttp.open('GET', "select_consulta.php?usuario="+usuario+"&id_mod="+id_mod);
				xmlhttp.onreadystatechange = function()
				{
					if( xmlhttp.readyState == 4 && xmlhttp.status == 200 )
					{  
						var cadena= new Array();
						var r = xmlhttp.responseText,
						//Convertimos la cadena a JSON
						cadena =JSON.parse(r),
						ul = document.createElement( 'ul' );
						if( cadena.length )
						{
							for( var i in cadena )
							{
								var li = document.createElement('li');
								li.innerHTML = cadena[i];
								ul.appendChild(li);
								
								var hora_inicial=cadena[i][2];
								var elem_ini = hora_inicial.split(':');
								var elem_ini1= elem_ini[1].split(' ');
								//alert(elem_ini[1]);
								var hora_ini = elem_ini[0];
								var minu_ini=elem_ini1[0];
								//var meridiano_ini=elem_ini1[1];
								
								var meridiano_ini=elem_ini.pop();
								
								//alert(hora_ini);
								//alert(minu_ini);
								//alert(meridiano_ini);
								
								var hora_final=cadena[i][3];
								var elem_fin = hora_final.split(':');
								var elem_finn = elem_fin[1].split(' ');
								
								var hora_fin = elem_fin[0];
								var minu_fin= elem_finn[0];
								//var meridiano_fin=elem_finn[1];
								var meridiano_fin=elem_fin.pop();
								
								
								//alert(hora_fin);
								//alert(minu_fin);
								//alert(meridiano_fin);
								
								
						var what1 = jQuery.trim(cadena[i][4]);	
						var fecha_ini = jQuery.trim(cadena[i][0]);	
						var fecha_fin = jQuery.trim(cadena[i][1]);						
								
document.getElementById('what').options[0]=new Option(what1,what1,"selected");
				document.form1['startDate'].value=fecha_ini;
				document.getElementById('endDate').value=fecha_fin;
				//alert(minu_ini);
				window.document.form1.startHour.value=hora_ini;
				//document.form1['startHour'].value= hora_ini;
				document.form1['endHour'].value= hora_fin;
				//document.form1['startMin'].value= hora_ini;
				window.document.form1.startMin.value=minu_ini;
				//document.form1['endMin'].value= minu_fin;
				window.document.form1.endMin.value=minu_fin;
				//alert(meridiano_ini);
				window.document.form1.startMeridiem.value= meridiano_ini;				window.document.form1.endMeridiem.value= meridiano_fin;
				//document.form1['startMeridiem'].value= meridiano_ini;
				//document.form1['endMeridiem'].value= meridiano_fin;
							}
						}
						$("#add-event-form").dialog('open');
						
					}
				}
				xmlhttp.send( null );
				
			},
			'Borrar': function() {//hay que hacer la parte de editar
				if(confirm("Esta seguro que quiere borrar este evento?")){
				
					if(clickAgendaItem != null){
						id=clickAgendaItem.agendaId;
						jfcalplugin.deleteAgendaItemById("#mycal",clickAgendaItem.agendaId);
						//jfcalplugin.deleteAgendaItemByDataAttr("#mycal","myNum",42);
						ajax=objetoAjax();
						ajax.open("GET", "eliminar_tarea.php?id="+id);
						ajax.onreadystatechange=function() 
						{
							if (ajax.readyState==4) 
							{
								divResultado1.innerHTML = ajax.responseText;
							}
						}
									ajax.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
						ajax.send(null);
						$(this).dialog('close');
					}
					
				}
			}			
		},
		open: function(event, ui){
			if(clickAgendaItem != null){
				var title = clickAgendaItem.title;
				var startDate = clickAgendaItem.startDate;
				var endDate = clickAgendaItem.endDate;
				var allDay = clickAgendaItem.allDay;
				var data = clickAgendaItem.data;
				var id= clickAgendaItem.id;
				// in our example add agenda modal form we put some fake data in the agenda data. we can retrieve it here.
				$("#display-event-form").append(
					"<br><b>" + title+ "</b><br><br>"		
				);				
				if(allDay){
					$("#display-event-form").append(
						"(Evento del Dia)<br><br>"				
					);				
				}else{
					$("#display-event-form").append(
						"<b>Fecha Inicial:</b> " + startDate + "<br>" +
						"<b>Fecha Final:</b> " + endDate + "<br><br>"				
					);				
				}
				for (var propertyName in data) {
					$("#display-event-form").append("<b>" + propertyName + ":</b> " + data[propertyName] + "<br>");
				}			
			}		
		},
		
		close: function() {
			// clear agenda data
			$("#display-event-form").html("");
		}
	});	 

	/**
	 * Initialize our tabs
	 */
	$("#tabs").tabs({
		/*
		 * Our calendar is initialized in a closed tab so we need to resize it when the example tab opens.
		 */
		show: function(event, ui){
			if(ui.index == 1){
				jfcalplugin.doResize("#mycal");
			}
		}	
	});
	
});
</script>
<table width="90%" border="0" align="center" class="main">
<tr>
<td>
<div id="tabs-2" style="background-color:#FFF;" >
	<div id="example" style="margin: auto; width:80%;">
		<br>
  <div id="toolbar">
	  <table width="100%" align="center" class="main">
  <tr class="titulo" >
    <td height="52" align="center">CRONOGRAMA DE TAREAS <?PHP ECHO $_SESSION['MM_Username'] ?></td>
  </tr>
</table>
  </div>
  </br>
		<div id="toolbar" class="ui-widget-header ui-corner-all" style="padding:3px; vertical-align: middle; white-space:nowrap; overflow: hidden;">
			<button id="BtnPreviousMonth">Mes Anterios</button>
			<button id="BtnNextMonth">Mes Siguiente</button>
			&nbsp;&nbsp;&nbsp;Fecha: 
			<input type="text" id="dateSelect" size="20"/>
			&nbsp;&nbsp;&nbsp;
			<button id="BtnDeleteAll">Limpiar Pantalla</button>
            <button id="CargarDatos">Cargar Datos</button>
		</div>
		<br>
		<div id="mycal"></div>
	</div>
        <!-- debugging-->
		<div id="calDebug"></div>
		<div id="add-event-form" title="Agregar Nuevo Evento">
			<p class="validateTips">Todos los campos son requeridos</p>
			<fieldset>
				<form name="form1" method="post"> 
				<table style="width:100%; padding:5px;">
					<tr>
						<td colspan="6">
							<label for="name">Evento?</label>
							<select id="what" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;">
								<option value="12" SELECTED>Tareas</option>
								<?php 
									mysql_select_db($database_conexion, $conexion);
									$query_tareas1 = "SELECT tar_codigo, tar_tarea, tar_fcumplimiento,  DATEDIFF(CURDATE(), tar_fingreso) as dias
									FROM tareas_tareas 
									INNER JOIN usuario ON tar_usu_asignado = usu_cod
									WHERE tar_estado = '0' 
									AND usu_nick = '".$_SESSION['MM_Username']."'";
									$tareas1 = mysql_query($query_tareas1, $conexion) or die(mysql_error());
									$row_tareas1 = mysql_fetch_assoc($tareas1);
									$totalRows_tareas1 = mysql_num_rows($tareas1);
								?>
								<?php
									do
									{
								?>
										<option value="<?php echo "(".$row_tareas1['tar_codigo'].")".$row_tareas1['tar_tarea'] ?>">
											<?php echo $row_tareas1['tar_tarea'] ?> 
										</option>
								<?php
									}while($row_tareas1 = mysql_fetch_assoc($tareas1));
								?>
							</select>
						</td>
					</tr>
					<tr>
						<td>
							<label>Fecha Inicial</label>
							<input type="text" name="startDate" id="startDate" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;"/>
							<div id="resultado"></div>	
						</td>
						<td>&nbsp;</td>
						<td>
							<label>Hora Inicial</label>
							<select id="startHour" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;">
								<option value="12" SELECTED>12</option>
								<option value="01">01</option>
								<option value="02">02</option>
								<option value="03">03</option>
								<option value="04">04</option>
								<option value="05">05</option>
								<option value="06">06</option>
								<option value="07">07</option>
								<option value="08">08</option>
								<option value="09">09</option>
								<option value="10">10</option>
								<option value="11">11</option>
							</select>				
						<td>
						<td>
						  <label>Minuto</label>
							<select id="startMin" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;">
								<option value="00" SELECTED>00</option>
                                <option value="01" >01</option>
                                <option value="02" >02</option>
                                <option value="03" >03</option>
                                <option value="04" >04</option>
                                <option value="05" >05</option>
                                <option value="06" >06</option>
                                <option value="07" >07</option>
                                <option value="08" >08</option>
                                <option value="09" >09</option>
                                <?php for($i=10;$i<=59;$i++)	{ ?>
                                
								<option value="<?php echo $i;?>"><?php echo $i;?></option>
                                <?php }?>
								
							</select>				
						<td>
						<td>
							<label> AM/PM</label>
							<select id="startMeridiem" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;">
							  <option value="AM" SELECTED>AM</option>
								<option value="PM">PM</option>
						  </select>				
					  </td>
					</tr>
					<tr>
						<td>
						  <label>Fecha Final</label>
							<input type="text"  id="endDate" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;"/>				
                            <input type="hidden" name="usuario" id="usuario" value="<?php echo $_SESSION['MM_Username'];?>" />
						</td>
						<td>&nbsp;</td>
						<td>
							<label>Hora Final</label>
							<select id="endHour" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;">
								<option value="12" SELECTED>12</option>
								<option value="01">01</option>
								<option value="02">02</option>
								<option value="03">03</option>
								<option value="04">04</option>
								<option value="05">05</option>
								<option value="06">06</option>
								<option value="07">07</option>
								<option value="08">08</option>
								<option value="09">09</option>
								<option value="10">10</option>
								<option value="11">11</option>
							</select>				
						<td>
						<td>
							<label>Minuto</label>
							<select id="endMin" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;">
								<option value="00" SELECTED>00</option>
								    <option value="01" >01</option>
                                <option value="02" >02</option>
                                <option value="03" >03</option>
                                <option value="04" >04</option>
                                <option value="05" >05</option>
                                <option value="06" >06</option>
                                <option value="07" >07</option>
                                <option value="08" >08</option>
                                <option value="09" >09</option>
								 <?php for($i=10;$i<=59;$i++)	{ ?>
                                
								<option value="<?php echo $i;?>"><?php echo $i;?></option>
                                <?php }?>
								
							</select>				
						<td>
						<td>
							<label>AM/PM</label>
							<select id="endMeridiem" class="text ui-widget-content ui-corner-all" style="margin-bottom:12px; width:95%; padding: .4em;">
								<option value="AM" SELECTED>AM</option>
								<option value="PM">PM</option>
							</select>				
						</td>				
					</tr>			
				</table>
				<table>
					<tr>
						<td>
							<label>Color del Evento</label> 
						</td>
						<td>
							<div id="colorSelectorBackground">
                            	<div style="background-color: #333333; width:30px; height:30px; border: 2px solid #000000;"></div>
                         	</div>
							<input type="hidden" name="colorBackground"  id="colorBackground" value="#333333">
						</td>
						<td>&nbsp;&nbsp;&nbsp;</td>
						<td>
							<label>Color del Texto</label>
						</td>
						<td>
							<div id="colorSelectorForeground">
                            	<div style="background-color: #ffffff; width:30px; height:30px; border: 2px solid #000000;"></div>
                            </div>
							<input type="hidden" name="colorForeground" id="colorForeground" value="#ffffff">
						</td>						
				  </tr>				
			    </table>
				</form>
			</fieldset>	
		</div>
		
	
	<div id="display-event-form" title="Tareas"></div>		
</div><!-- end example tab -->
</br>
</td>
</tr>
</table>
	
	<div id="tabs-3">
	
<!--

Begin Documentation

-->

<style type="text/css">
a {
  font: 11px/14px georgia, times, verdana, arial, helvetica, sans-serif;
  text-decoration:none;
}
a:hover { background-color:#ccc; }
a:link { color:royalblue; }
a:visited { color:royalblue; }
.code, .info, .codeHead, .apiHead, .api {
	background-color: #dddddd;
	color: #000000;
	font: 11px/14px verdana, georgia, times, arial, helvetica, sans-serif;
	line-height: 18px;
	padding: 3px;
	margin: 0px;
}
.codeHead {
	background-color: #bbbbbb;
}
.info {
	background-color: #ffffff;
	color: #444444;
}
.apiHead{
	background-color: #dedede;
	color: #000000;
}
.api {
	background-color: #ffffff;
	color: #333333;
}

textarea.code {
	width: 100%; height: 300px; padding:0px; margin:0px; font-size:1.2em; font-family:monospace; background-color: #efefef; color: #222222;
}
	
table.apiTable {
	border-width: 0px 0px 0px 0px;
	border-spacing: 2px;
	border-style: outset outset outset outset;
	border-color: gray gray gray gray;
	border-collapse: collapse;
	background-color: #ffffff;
	width: 100%;
}
table.apiTable th {
	font: 12px/12px verdana, georgia, times, arial, helvetica, sans-serif;
	font-weight: bold;
	text-align: left;
	color: #555555;
	border-width: 1px 1px 1px 1px;
	padding: 3px 3px 3px 3px;
	border-style: inset inset inset inset;
	border-color: rgb(200,200,200);
	background-color: #ffffff;
	-moz-border-radius: 0px 0px 0px 0px;
}
table.apiTable td {
	font: 12px/12px verdana, georgia, times, arial, helvetica, sans-serif;
	color: #555555;
	border-width: 1px 1px 1px 1px;
	padding: 3px 3px 3px 3px;
	border-style: inset inset inset inset;
	border-color: rgb(200,200,200);
	background-color: #ffffff;
	-moz-border-radius: 0px 0px 0px 0px;
}
</style>	
</body>
</html>
