BEGIN
  DECLARE done INT DEFAULT 0;
  DECLARE vgas_descripcion VARCHAR(45);
  DECLARE vtotalgen, vpresupuesto, vsubtotal, votrosgastos, vadvalorem, vfodinfa, vmodernizacion, vcontrol, vice, vimpsalida, vsalvaguardia, vseguro, vcorpei, vfleteint DOUBLE(14,2) DEFAULT 0;
  DECLARE vprovcod, vilc_tnego, vter_fleteint, vter_seguroint, vter_gastonac, vter_gastoint INT  DEFAULT 0;
  DECLARE ptadv, tot_advcal, vilc_texw, vilc_tgastosfob, vilc_tfletes, vilc_tseguro, vilc_tgastosop, vop_exworkmn, vop_gastosmn, vop_fletemn, vop_seguromn DOUBLE(14,2) DEFAULT 0;
  DECLARE vilc_tcambio, vild_porexwork, vild_portoneladas DOUBLE(14,4) DEFAULT 0;
  DECLARE vilc_estado3 CHAR;
  DECLARE vild_partida, vild_cinterno VARCHAR(20);
  DECLARE vild_preferencia VARCHAR(3);
  DECLARE qlar_partida VARCHAR(100);
  DECLARE qlar_preferencia VARCHAR(3);
  DECLARE qlar_proforma, var INT DEFAULT 0;
  DECLARE qlar_nroorden VARCHAR(45);
  DECLARE qlar_pexwork, qlar_ptoneladas, val_ex DOUBLE(9,5) DEFAULT 0;
  DECLARE qlar_exw, qlar_sumatoria, qlar_sumatoriaton, qlar_alicota, qlar_alicotaton, qlar_advalorem, qlar_fodinfa, qlar_control, qlar_modernizacion, qlar_valsalvaguardia, qlar_porice DOUBLE(14,6) DEFAULT 0;
  DECLARE qlar_salvaguardia, qlar_iva, qlar_ice, qlar_corpei CHAR(1);
  DECLARE por_saldivisa, val_saldivisa, lim_corpei, val_corpei, por_corpei, val_tcambio, val_gnacionales, val_exworkmn, vdiferencia DOUBLE(14,2) DEFAULT 0;
  DECLARE val_gastosmn, val_fletemn, val_seguromn, val_totalmn, val_exworkmi, val_gastosmi, val_fletemi, val_seguromi,vdiferencia_partida DOUBLE(14,2) DEFAULT 0;
  DECLARE val_totalmi, val_divisa, valor_corpei, Gfob, por_iva, vtotal_g, tot_parancel, val_cif, total_exwork DOUBLE(14,2) DEFAULT 0;

  DECLARE cur_gastos CURSOR FOR SELECT gas_descripcion, SUM(gop_presupuesto), sum(gtn_subtotal)
  FROM `imp_gatosop` INNER JOIN imp_gastos ON gas_codigo = gop_codgasto
  WHERE  gop_cproforma = proforma GROUP BY gop_codgasto;

  DECLARE cur_liqdetalle CURSOR FOR
  SELECT lar_partida, lar_preferencia
  FROM `imp_liqarancel` WHERE lar_proforma = proforma group by lar_partida, lar_preferencia;


  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

 -- SACAMOS EL TOTAL DE ARANCELES QUE DEBERIAMOS PAGAR SEGUN LOS VALORES INGRESADOS, PARA LUEGO PRORRATEAR CON EL VALOR QUE NOS COBRA ADUANAS.
  SELECT SUM((ild_canllego / ild_ucaja) * ild_exw * lar_advalorem / 100) INTO tot_parancel FROM `imp_liqdetalle`
  INNER JOIN `imp_liqarancel` ON ild_partida = lar_partida AND ild_preferencia = lar_preferencia AND ild_proforma = lar_proforma
  WHERE ild_proforma = proforma;

 -- SACAMOS LA INFORMACION DE LA IMPORTACION, TOTALES.
  SELECT op_tcambio, op_gnacionales, op_exworkmn, op_gastosmn, op_fletemn, op_seguromn, op_totalmn, op_exworkmi, op_gastosmi, op_fletemi, op_seguromi, 
op_totalmi,(SELECT ifnull((SELECT op_diferencia from imp_liqcabecera, imp_opedido where imp_opedido.op_nroorden = imp_liqcabecera.ilc_proforma and imp_liqcabecera.ilc_estado3 = 'A' AND
imp_opedido.op_nroorden = proforma),0)
FROM
imp_opedido
WHERE
imp_opedido.op_nroorden = proforma)
  INTO val_tcambio, val_gnacionales, val_exworkmn, val_gastosmn, val_fletemn, val_seguromn, val_totalmn, val_exworkmi, val_gastosmi, val_fletemi, val_seguromi, val_totalmi, vdiferencia
  FROM `imp_opedido` WHERE op_nroorden = proforma;

-- SACAR EL NUEVO EXWOR TOTAL DE LA IMPORTACION PARA LUEGO SACAR LOS PORCENTAJES EXWORK
			SELECT
			Sum((ild_canllego*ild_ucaja)*ild_exw) INTO total_exwork
			FROM
			imp_liqdetalle
			INNER JOIN imp_opedido ON ild_proforma = op_nroorden
			WHERE
			ild_proforma = proforma
			GROUP BY ild_proforma;




  SELECT provcod, ilc_tnego, ilc_tcambio, ilc_texw, ilc_tgastosfob, ilc_tfletes, ilc_tseguro, ilc_tgastosop, ter_gastoint, ter_fleteint, ter_seguroint, ter_gastonac, op_exworkmn, op_gastosmn, op_fletemn, op_seguromn, ilc_estado3
  INTO vprovcod, vilc_tnego, vilc_tcambio, vilc_texw, vilc_tgastosfob, vilc_tfletes, vilc_tseguro, vilc_tgastosop, vter_gastoint, vter_fleteint, vter_seguroint, vter_gastonac, vop_exworkmn, vop_gastosmn, vop_fletemn, vop_seguromn, vilc_estado3
  FROM `imp_liqcabecera`
  INNER JOIN `provedor` ON ilc_proveedor = provedor.provcod
  INNER JOIN `imp_opedido` ON ilc_proforma = op_nroorden
  INNER JOIN `imp_terminos` ON ter_codigo = ilc_tnego
  WHERE ilc_proforma = proforma;

IF vilc_estado3 = 'A' THEN

-- CALCULAMOS EL PORCENTAJE QUE LE PRETENECE A CADA PRODUCTO POR INDIVIDUAL, ESTE PRORRATEO SE HACER SEGUN EL VALOR EXWORK.
  UPDATE `imp_liqdetalle` SET ild_porexwork_rec = (((ild_canllego*ild_ucaja)*ild_exw) / total_exwork) WHERE ild_proforma = proforma;
  
-- CUANDO LA IMPORTACION ESTA APROBADA  PARA RECALCULAR COSTOS EN  LA PRELIQUIDACION.
    UPDATE `imp_liqdetalle` SET ild_diferencia = 0
    WHERE ild_proforma = proforma;

-- PONEMOS EN 0 LOS VALORES DE PRORRATEO EN LA DIFERENCIA.
    UPDATE imp_liqdetalle SET ild_difuni_b =vdiferencia* ild_porexwork/ild_canllego
    WHERE ild_proforma = proforma;

-- grabamos las partidas arancelarias con toda la informacion para porder realizar los calculos.
    
		DELETE FROM `imp_liqarancel` WHERE lar_proforma = proforma;
    INSERT INTO `imp_liqarancel` 
		SELECT ild_partida, ild_preferencia, ild_proforma, ild_nroorden,
    (SUM(ild_canllego / ild_ucaja * ild_exw))/(total_exwork), 0,
    (total_exwork), 0, 0, 0, 0,
    SUM(ild_canllego / ild_ucaja * (ild_exw)),
    SUM( ild_totalpesvol ), 0, 0, advaloren, fodinfa, control, modernizacion, salvaguardia, iva, ice, corpei, valsalvaguardia, valice,0
    FROM imp_liqdetalle
    INNER JOIN imp_liqcabecera ON ilc_proforma = ild_proforma
    INNER JOIN imp_aranceles ON ild_partida = ara_codigoaran AND ild_preferencia = ara_preferencia
    INNER JOIN provedor ON provcod = ilc_proveedor
    INNER JOIN imp_nacionarancel ON procodnacion = nacion_codigo AND arancel_codigo = ara_codigo AND estado = 0
    WHERE ild_proforma = proforma GROUP BY ild_partida, ild_preferencia;

  
	ELSE

-- EN EL CASO DE QUE NOS TOQUE REALIZAR NOTAS DE CREDITO O DEBITO.
-- SACAMOS EL VALOR DE LA DIFERENCIA DE LOS PRODUCTOS.
    UPDATE imp_liqdetalle SET ild_diferencia = if((ild_cantidad * ild_ucaja)-(ild_canllego)>0,(ild_cantidad * ild_ucaja)-(ild_canllego),0)
    WHERE ild_proforma = proforma;

-- PONEMOS EN 0 LOS VALORES DE PRORRATEO EN LA DIFERENCIA.
    UPDATE imp_liqdetalle SET ild_difepro_b = 0, ild_difuni_b = 0
    WHERE ild_proforma = proforma;

-- SACAMO EL VALOR TOTAL DEL EXWORK DE TODA LA IMPORTACION.
    SELECT SUM(ild_canllego / ild_ucaja * (ild_exw + ild_difuni_b)) INTO val_exworkmn FROM imp_liqdetalle WHERE ild_proforma = proforma;

-- grabamos las partidas arancelarias con toda la informacion para porder realizar los calculos.
    DELETE FROM imp_liqarancel WHERE lar_proforma = proforma;
    INSERT INTO imp_liqarancel SELECT ild_partida, ild_preferencia, ild_proforma, ild_nroorden,
    SUM((ild_canllego / ild_ucaja * (ild_exw + ild_difuni_b))/(val_exworkmn)), 0,
    (val_exworkmn), 0, 0, 0, 0,
    SUM(val_exworkmn * (ild_canllego / ild_ucaja * (ild_exw + ild_difuni_b))/(val_exworkmn)),
    SUM( ild_totalpesvol ), 0, 0, advaloren, fodinfa, control, modernizacion, salvaguardia, iva, ice, corpei, valsalvaguardia, valice,0
    FROM imp_liqdetalle
    INNER JOIN imp_liqcabecera ON ilc_proforma = ild_proforma
    INNER JOIN imp_aranceles ON ild_partida = ara_codigoaran AND ild_preferencia = ara_preferencia
    INNER JOIN provedor ON provcod = ilc_proveedor
    INNER JOIN imp_nacionarancel ON procodnacion = nacion_codigo AND arancel_codigo = ara_codigo AND estado = 0
    WHERE ild_proforma = proforma GROUP BY ild_partida, ild_preferencia;
  END IF;


-- SACAMO LOS VALORES REALES DE LOS GATOS PARA REALIZAR LOS CALCULOS EN LA PRELIQUIDACION.
  OPEN cur_gastos;
  REPEAT
  FETCH cur_gastos INTO vgas_descripcion, vsubtotal, vpresupuesto;
  IF NOT done THEN
    CASE vgas_descripcion
      WHEN 'ADVALOREM' THEN
        SET vadvalorem = vpresupuesto;
      WHEN 'FODINFA' THEN
        SET vfodinfa = vpresupuesto;
      WHEN 'MODERNIZACION' THEN
        SET vmodernizacion = vpresupuesto;
      WHEN 'CONTROL' THEN
        SET vcontrol = vpresupuesto;
      WHEN 'ICE' THEN
        SET vice = vpresupuesto;
      WHEN 'SALVAGUARDIA' THEN
        SET vsalvaguardia = vpresupuesto;
      WHEN 'CORPEI' THEN
        SET vcorpei = vpresupuesto;
      ELSE
        SET votrosgastos = votrosgastos + vpresupuesto;
    END CASE;
  END IF;
  UNTIL done END REPEAT;
  CLOSE cur_gastos;

  SET vtotalgen = vfodinfa + vmodernizacion + vcontrol + vice + vsalvaguardia;

  SET val_cif = val_gastosmn + val_fletemn + val_seguromn;

  SET done = 0;

-- VAMOS A RECORER CADA UNOS DE LOS DE LOS ITEMS AGRUPADOS POR PARTIDA ARANCELARIA.
  OPEN cur_liqdetalle;
  REPEAT
  FETCH cur_liqdetalle INTO vild_partida, vild_preferencia;
  IF NOT done THEN
-- REALIZAMOS EL PRORRATEO DEL ADVALOREM.
    SELECT SUM(lar_advalorem/100) INTO qlar_advalorem
    FROM `imp_liqarancel`
    WHERE lar_proforma = proforma AND
    lar_partida = CONVERT(vild_partida using utf8) collate utf8_general_ci  AND
    lar_preferencia = CONVERT(vild_preferencia using utf8) collate utf8_general_ci;

-- SUBDIVIDIMOS LOS VALORES PARA PORDER SACAR LA ALICOTA DE CADA UNA DE LAS PARTIDAS ARANCELARIAS.
    UPDATE `imp_liqarancel`
    SET lar_vgastos = (votrosgastos+vdiferencia) * lar_pexwork ,
    lar_vadv = IFNULL((((lar_sumatoria * qlar_advalorem)/tot_parancel)*vadvalorem),0),
    lar_varnceles = vtotalgen * lar_pexwork,
		lar_diferencia=vdiferencia * lar_pexwork,
    lar_vcif = val_cif * lar_pexwork
    WHERE lar_partida = CONVERT(vild_partida using utf8) collate utf8_general_ci  AND
    lar_preferencia = CONVERT(vild_preferencia using utf8) collate utf8_general_ci AND lar_proforma = proforma;

-- SACMAMOS LA ALICUOTA DE CADA UNA DE LAS PARTIDAS ARANCELARIAS.
    UPDATE `imp_liqarancel`
    SET lar_alicota = (lar_vgastos + lar_vadv + lar_varnceles + lar_sumatoria + lar_vcif) / lar_sumatoria
    WHERE lar_partida = CONVERT(vild_partida using utf8) collate utf8_general_ci  AND
    lar_preferencia = CONVERT(vild_preferencia using utf8) collate utf8_general_ci AND lar_proforma = proforma;

-- COLOCAMOS LA ALICUOTA EN LA TABLA DEL DETALLE DE LA IMPORTACION.
     UPDATE `imp_liqdetalle` SET ild_presalicota =
    (SELECT lar_alicota FROM `imp_liqarancel`
    WHERE lar_partida = CONVERT(vild_partida using utf8) collate utf8_general_ci  AND lar_preferencia = CONVERT(vild_preferencia using utf8) collate utf8_general_ci AND lar_proforma = proforma )
    WHERE ild_partida = CONVERT(vild_partida using utf8) collate utf8_general_ci  AND ild_preferencia = CONVERT(vild_preferencia using utf8) collate utf8_general_ci AND ild_proforma = proforma;

-- CALULAMOS EL COSTO DEL PRODUCTO.
    UPDATE `imp_liqdetalle` SET
    ild_costoexw = (ild_presalicota * (ild_exw) / ild_ucaja),
    ild_costoton = (ild_presalicotaton * (ild_exw) / ild_ucaja)
    WHERE ild_partida = CONVERT(vild_partida using utf8) collate utf8_general_ci  AND ild_preferencia = CONVERT(vild_preferencia using utf8) collate utf8_general_ci AND ild_proforma = proforma;
  END IF;
  UNTIL done END REPEAT;
  CLOSE cur_liqdetalle;

END