<?php
//Include las clases
require_once 'class/categorias.php';
require_once 'class/foros.php';
require_once 'class/temas.php';
require_once 'class/comentarios.php';
require_once('../Connections/conexion.php'); 

if (!isset($_SESSION)) {
  session_start();
	$_SESSION['MM_Username'];
	$cod_usuario_s= $_SESSION['MM_Usercode'];
}
$MM_authorizedUsers = "";
$MM_donotCheckaccess = "true";

// *** Restrict Access To Page: Grant or deny access to this page
function isAuthorized($strUsers, $strGroups, $UserName, $UserGroup)
 { 
  // For security, start by assuming the visitor is NOT authorized. 
  $isValid = False; 
  // When a visitor has logged into this site, the Session variable MM_Username set equal to their username. 
  // Therefore, we know that a user is NOT logged in if that Session variable is blank. 
  if (!empty($UserName)) { 
    // Besides being logged in, you may restrict access to only certain users based on an ID established when they login. 
    // Parse the strings into arrays. 
    $arrUsers = Explode(",", $strUsers); 
    $arrGroups = Explode(",", $strGroups); 
    if (in_array($UserName, $arrUsers)) { 
      $isValid = true; 
    } 
    // Or, you may restrict access to only certain users based on their username. 
    if (in_array($UserGroup, $arrGroups)) { 
      $isValid = true; 
    } 
    if (($strUsers == "") && true) { 
      $isValid = true; 
    } 
  } 
  return $isValid; 
}

$MM_restrictGoTo = "../main/error.php";
if (!((isset($_SESSION['MM_Username'])) && (isAuthorized("",$MM_authorizedUsers, $_SESSION['MM_Username'], $_SESSION['MM_UserGroup'])))) {   
  $MM_qsChar = "?";
  $MM_referrer = $_SERVER['PHP_SELF'];
  if (strpos($MM_restrictGoTo, "?")) $MM_qsChar = "&";
  if (isset($_SERVER['QUERY_STRING']) && strlen($_SERVER['QUERY_STRING']) > 0) 
  $MM_referrer .= "?" . $_SERVER['QUERY_STRING'];
  $MM_restrictGoTo = $MM_restrictGoTo. $MM_qsChar . "accesscheck=" . urlencode($MM_referrer);
  header("Location: ". $MM_restrictGoTo); 
  exit;
}
// creamos el objeto categorias
$objC = new Categorias();

include 'header.php';

$categorias = $objC->getCategorias();
foreach ($categorias as $cat) {
    $categoria = $cat["id_forocategoria"];
    ?>
    <div class="caja">
        <div class="categorias">
            <a name="<?php echo $cat["categoria"]; ?>"></a><?php echo $cat["categoria"]; ?>
        </div>
        <?php
        $objF = new Foros();
        $foros = $objF->getForo($categoria);
		if (sizeof($foros) > 0) 
		{
        	foreach ($foros as $foro) {
            ?>
            	<div class="foro">
                	<div class="foro_icono">
                    	<img src="img/note.png">
                	</div>
                	<div class="foro_titulo">
                    	<a href="temas.php?foro=<?php echo $foro["id_foro"]; ?>"><?php echo $foro["foro"]; ?></a><br>
                	</div>
                	<div class="temas_mensajes">
                    	<?php
                    	$objTemas = new Temas();
                    	$total = $objTemas->TotalTemas($foro["id_foro"]);
                    	?>
                    	Temas: <?php echo $total; ?><br>
	                    <?php
    	                $objCom = new Comentarios();
        	            $totalcom = $objCom->TotalComentariosForo($foro["id_foro"]);
            	        ?>
                	    Mensajes: <?php echo $totalcom; ?><br>
                	</div>
                	<div class="ultimocomentario">
                    	<?php
                    	$objMensajes = new Comentarios();
	                    $mensaje = $objMensajes->ultimo_comentario($foro["id_foro"]);
    	                if (sizeof($mensaje) > 0) {
        	                echo "Titulo: " . $mensaje[0]["titulo"] . "<br/>";
            	            echo "por: " . $mensaje[0]["nick"] . "<br/>";
                	        echo "Fecha: " . $mensaje[0]["fecha"];
                    	} else {
                        	echo 'No hay comentarios';
                    	}				
		    ?>
                </div>
                <div style="clear:both; height:1px;font-size:0px; line-height: 0px;"></div>
            </div>
            <?php
			}
		}
		else
		{
			?><br><?php echo 'No se ha ingresado ningún Foro dentro de esta Categoria';?><br>
            <?php
		}
        ?>
    </div>

    <?php
}
?>
<div class="caja">
</div>
<?php
include 'footer.php';
