<?php
require('../fpdf/fpdf.php');
require_once('../../Connections/conexion.php');

class PDF extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
	//Set the array of column widths
	$this->widths=$w;
}

function SetAligns($a)
{
	//Set the array of column alignments
	$this->aligns=$a;
}

function Row($data)
{
	//Calculate the height of the row
	$nb=0;
	for($i=0;$i<count($data);$i++)
		$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
	$h=5*$nb;
	//Issue a page break first if needed
	$this->CheckPageBreak($h);
	//Draw the cells of the row
	for($i=0;$i<count($data);$i++)
	{
		$w=$this->widths[$i];
		$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
		//Save the current position
		$x=$this->GetX();
		$y=$this->GetY();
		//Draw the border
		
		$this->Rect($x,$y,$w,$h);

		$this->MultiCell($w,5,$data[$i],0,$a,'true');
		//Put the position to the right of the cell
		$this->SetXY($x+$w,$y);
	}
	//Go to the next line
	$this->Ln($h);
}

function CheckPageBreak($h)
{
	//If the height h would cause an overflow, add a new page immediately
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
	//Computes the number of lines a MultiCell of width w will take
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
}

function Header()
{

	    global $title;
		global $fecha;
		global $ruc;
		global $telf;
		global $fax;
		global $page;
		$this->Image('../../imagenes/lempresatononegro.jpg' , 140 , 10, 50 , 15,'JPG', '');
		$this->SetFont('Times','B',8); 
		$this->SetFillColor(192,192,192);
	//	$this->Cell(110,4,$title,'',0,'L',0); 
		$this->Cell(80,4,'','',0,'C');
		$this->Ln();
		$this->Cell(80,4,'','',0,'C');
		$this->Ln();
		$this->Cell(110,4,'','',0,'L',0); 
		$this->Cell(80,4,'','',0,'C');
		$this->Ln();
//		$this->Cell(110,4,'Telf: '.$telf."  -  Fax: ".$fax,'',0,'L',0);
//		$this->Cell(80,4,'','',0,'C');
//		$this->Ln();
		$this->Cell(110,4,'COMPROBANTE MULTA','',0,'L',0); 
		$this->Cell(80,4,'','',0,'C');
		$this->Ln();
		$this->Cell(190,0,'','B',0,'C');
		$this->Ln(4);
}

function Footer()
{
	$this->SetY(-15);
	$this->SetFont('Arial','B',8);
	$this->Cell(100,10,'',0,0,'L');

}

}

	$numero= $_GET['numero'];
	//$con = new DB;
	//$pacientes = $con->conectar();	
	
	mysql_select_db($database_conexion, $conexion);
	//$strConsulta = "SELECT * from pacientes where id_paciente =  '$paciente'";
	$strConsulta = "SELECT sysdate() as fechaemi,numero,empleado,fecha,concepto,valor,fechades,concat( emp_apellido, ' ', emp_nombre ) as nombres from empleado_kardex  ,empleado where emp_codigo=empleado and empleado_kardex.tipo=53 and numero=".$numero ;
	$multas = mysql_query($strConsulta,$conexion);
	$fila = mysql_fetch_array($multas);
	

	///////////////////////


	$pdf=new PDF('l','mm','A5');
	$pdf->Open();
	$pdf->AddPage();
	$pdf->SetMargins(20,20,20);
	 $pdf->SetFont('Arial','B',7);
	$pdf->Cell(0,6,'',0,1);
	$pdf->Ln(4);


    $pdf->SetFont('Arial','',7);
	
	if (strlen($fila['concepto'])>70)
	{
		$concepto=substr($fila['concepto'],0,80)."\n";
		$concepto1=substr($fila['concepto'],81,strlen($fila['concepto']))."\n";
	}
	else
	{
		$concepto=$fila['concepto'];
	}
	
	
	
	
	$pdf->Cell(0,6,'Fecha: '.$fila['fechaemi'],0,1);
    $pdf->Cell(0,6,'Codigo Empleado: '.$fila['empleado'],0,1);
	$pdf->Cell(0,6,'Nombres Empleado: '.$fila['nombres'],0,1);
	if (strlen($fila['concepto'])>80)
	{
	$pdf->Cell(0,6,'Motivo de la Multa: '.$concepto,0,1); 
	$pdf->Cell(0,6,''.$concepto1,0,1); 
	}
	else
	{
	$pdf->Cell(0,6,'Motivo de la Multa: '.$concepto,0,1); 
	}
	
	$pdf->Cell(0,6,'Valor de la Multa: '.$fila['valor'],0,1); 	
	$pdf->Cell(0,6,'Fecha Descuento: '.$fila['fechades'],0,1); 	
	
	
	$pdf->Ln(10);
	
	$pdf->SetWidths(array(7, 15, 100, 15, 10,15,15));
	$pdf->SetFont('Arial','B',6);
	//$pdf->SetFillColor(104,131,139);
    //$pdf->SetTextColor(255);

	$pdf->Cell(0,6,'____________________________ ',0,1); 	
	$pdf->Cell(0,6,'          Firma Empleado ',0,1); 	
		
		for($i=0;$i<1;$i++)
			{
				//$pdf->Row(array('TIPO', 'NUMERO', 'CONCEPTO', 'FECHA', 'CARGO', 'DESCARGO','SALDO'));
			}
	
			
$pdf->Output();
?>