DELIMITER //
CREATE TRIGGER IngPais AFTER INSERT ON upais
FOR EACH ROW BEGIN
CALL PaisArancel(NEW.pais_codigo, NEW.pais_certificado);
END

DELIMITER //
CREATE PROCEDURE PaisArancel(IN codigo_pais INTEGER, IN pais_certificado INTEGER )
BEGIN 
    DECLARE done INT DEFAULT 0;   
    DECLARE ara_codigo INT DEFAULT 0;
    DECLARE fodinfa1 DOUBLE(14,4) DEFAULT 0;
    DECLARE advaloren1 DOUBLE(14,4) DEFAULT 0;
    DECLARE modernizacion1 DOUBLE(14,4) DEFAULT 0;
    DECLARE salvaguardia1 CHAR(1);
    DECLARE ice1 CHAR(1);
    DECLARE iva1 CHAR(1);
    DECLARE corpei1 CHAR(1);
    DECLARE control1 DOUBLE(14,4) DEFAULT 0;

    DECLARE cur1 CURSOR FOR SELECT arancel_codigo, fodinfa, max(advaloren), modernizacion, salvaguardia, ice, iva, corpei, control FROM imp_nacionarancel GROUP BY arancel_codigo;
    DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
    
    OPEN cur1;
    
    REPEAT
    FETCH cur1 INTO ara_codigo, fodinfa1, advaloren1, modernizacion1, salvaguardia1, ice1, iva1, corpei1, control1;
    IF NOT done THEN
        IF pais_certificado = '1' THEN
            set advaloren1 = 1000;
	        INSERT INTO imp_nacionarancel VALUES (ara_codigo, codigo_pais, fodinfa1, advaloren1, modernizacion1, salvaguardia1, ice1, iva1, corpei1, control1, sysdate(),0);
        ELSE
            INSERT INTO imp_nacionarancel VALUES (ara_codigo, codigo_pais, fodinfa1, advaloren1, modernizacion1, salvaguardia1, ice1, iva1, corpei1, control1, sysdate(),0);
        END IF;
    END IF;
    UNTIL done END REPEAT;
   
    CLOSE cur1;      
END

DELIMITER //
CREATE TRIGGER CreaProducto AFTER INSERT ON producto
FOR EACH ROW BEGIN
	DECLARE secuencia INT DEFAULT 0;
	UPDATE producto_grupo SET lin_secuencial = lin_secuencial + 1 WHERE lin_codigofin = NEW.codigo_linea;
    INSERT INTO producto_profomas (producto) VALUES (NEW.codigo_concatenado);    
    INSERT INTO kardex (kar_tipo, codproducto, kar_codtransa, kar_detalle, kar_fecha) VALUES ('INICIO',NEW.codigo_concatenado,'0', 'CARGA INICIAL', sysdate());		
END

DELIMITER //
CREATE TRIGGER CreaProformImportaciones AFTER INSERT ON imp_proforma
FOR EACH ROW BEGIN
    INSERT INTO imp_opedido (op_nroorden, op_codproveedor) VALUES (NEW.pf_codigo , NEW.pf_codprov);    
    INSERT INTO imp_liqcabecera (ilc_proforma, ilc_proveedor) VALUES (NEW.pf_codigo , NEW.pf_codprov);		
END

DELIMITER //
CREATE TRIGGER ModificarProformImportaciones AFTER UPDATE ON imp_proforma
FOR EACH ROW BEGIN
    UPDATE imp_opedido SET op_nombre = NEW.pf_nroorden WHERE op_nroorden = NEW.pf_codigo;
    UPDATE imp_liqcabecera SET ilc_nroorden = NEW.pf_nroorden WHERE ilc_proforma = NEW.pf_codigo;
    UPDATE imp_archivos SET arc_nroorden = NEW.pf_nroorden WHERE arc_proforma = NEW.pf_codigo;
    UPDATE imp_cuotas SET icu_nroorden = NEW.pf_nroorden WHERE icu_proforma = NEW.pf_codigo;
    UPDATE imp_liqarancel SET lar_nroorden = NEW.pf_nroorden WHERE lar_proforma = NEW.pf_codigo;
    UPDATE imp_liqdetalle SET ild_nroorden = NEW.pf_nroorden WHERE ild_proforma = NEW.pf_codigo;
    UPDATE imp_lotes SET lot_nroorden = NEW.pf_nroorden WHERE lot_proforma = NEW.pf_codigo;
    UPDATE imp_opcuotas SET opc_orden = NEW.pf_nroorden WHERE opc_proforma = NEW.pf_codigo;
    UPDATE imp_proorden SET pop_ordcom = NEW.pf_nroorden WHERE pop_cproforma = NEW.pf_codigo;
    UPDATE imp_series SET ser_nroorden = NEW.pf_nroorden WHERE ser_proforma = NEW.pf_codigo;
    UPDATE imp_proorden SET pop_ordcom = NEW.pf_nroorden WHERE pop_cproforma = NEW.pf_codigo;    
END

DELIMITER //
CREATE TRIGGER IngresoProductosImportacion AFTER INSERT ON imp_pproducto
FOR EACH ROW BEGIN
	DECLARE partida VARCHAR(15);
    DECLARE preferencia VARCHAR(3);
    DECLARE unicaja INT;
    DECLARE largo DOUBLE(14,2);
    DECLARE profundidad DOUBLE(14,2);
    DECLARE alto DOUBLE(14,2);
    DECLARE peso DOUBLE(14,2);
    
    SELECT partida_arancelaria INTO partida FROM producto WHERE codigo_concatenado = NEW.pp_cprod;
    SELECT preferencia_arancelaria INTO preferencia FROM producto WHERE codigo_concatenado = NEW.pp_cprod;
    SELECT unidad_caja INTO unicaja FROM producto WHERE codigo_concatenado = NEW.pp_cprod;
    SELECT volumen_lago_caja INTO largo FROM producto WHERE codigo_concatenado = NEW.pp_cprod;
    SELECT volumen_ancho_caja INTO profundidad FROM producto WHERE codigo_concatenado = NEW.pp_cprod;
    SELECT volumen_alto_caja INTO alto FROM producto WHERE codigo_concatenado = NEW.pp_cprod;
    SELECT peso_caja INTO peso FROM producto WHERE codigo_concatenado = NEW.pp_cprod;
    
    INSERT INTO imp_proorden (pop_partida, pop_preferencia, pop_nombrep, pop_cproforma, pop_ordcom, pop_codproducto, pop_cprod, pop_cata, pop_cantidad, pop_componente, pop_orden, pop_ucaja, pop_largo, pop_profundidad, pop_alto, pop_peso) VALUES (partida, preferencia, NEW.pp_nombrep, NEW.pp_codproforma, '-1', NEW.pp_codproducto, NEW.pp_cprod, NEW.pp_codcatalogo, NEW.pp_cantidad, NEW.pp_componente, NEW.pp_orden, unicaja, largo, profundidad, alto, peso);        
    
    INSERT INTO imp_liqdetalle (ild_proforma, ild_nroorden, ild_partida, ild_preferencia, ild_cinterno, ild_codprod, ild_nomprod, ild_cantidad, ild_ucaja, ild_largo, ild_profundidad, ild_alto, ild_pesokg, ild_orden) VALUES (NEW.pp_codproforma, '-1', partida, preferencia, NEW.pp_codproducto, NEW.pp_cprod, NEW.pp_nombrep, NEW.pp_cantidad, unicaja, largo, profundidad, alto, peso, NEW.pp_orden);		
END

DELIMITER //
CREATE TRIGGER EliminarProductosImportacion AFTER DELETE ON imp_pproducto
FOR EACH ROW BEGIN
    DELETE FROM imp_proorden WHERE pop_cproforma = OLD.pp_codproforma and pop_codproducto = OLD.pp_codproducto;
    DELETE FROM imp_liqdetalle WHERE ild_proforma = OLD.pp_codproforma and ild_cinterno = OLD.pp_codproducto;    	
    DELETE FROM imp_pcomponente WHERE ipc_proforma = OLD.pp_codproforma and ipc_producto = OLD.pp_codproducto;    	
END

DELIMITER //
CREATE TRIGGER ModificarProductosImportacion AFTER UPDATE ON imp_pproducto
FOR EACH ROW BEGIN
    UPDATE imp_proorden SET pop_cantidad = NEW.pp_cantidad WHERE pop_cproforma = NEW.pp_codproforma and pop_codproducto = NEW.pp_codproducto;
    UPDATE imp_liqdetalle SET ild_cantidad = NEW.pp_cantidad WHERE ild_proforma = NEW.pp_codproforma and ild_cinterno = NEW.pp_codproducto;    
END

DELIMITER //
CREATE TRIGGER ModificaOrdenPedido AFTER UPDATE ON imp_opedido
FOR EACH ROW BEGIN
   
    UPDATE imp_liqcabecera SET ilc_tnego = NEW.op_termino, ilc_transporte = NEW.op_transporte, ilc_moneda = NEW.op_moneda, ilc_tcambio = NEW.op_tcambio, ilc_fpago = NEW.op_fpago, ilc_tpago = NEW.op_tpago, ilc_texw = NEW.op_exworkmi, ilc_tgastosfob = NEW.op_gastosmi, ilc_tfletes = NEW.op_fletemi, ilc_tseguro = NEW.op_seguromi, ilc_tgastosop= NEW.op_gnacionales, ilc_pesoneto = NEW.op_pesoneto, ilc_pesobruto = NEW.op_pesobruto, ilc_numerovl = NEW.op_numerovl, ilc_numcontenedor = NEW.op_numcontenedor, ilc_numbultos = NEW.op_numbultos, ilc_apliseguros = NEW.op_aplseguros WHERE ilc_proforma = NEW.op_nroorden; 
    
  UPDATE imp_liqdetalle SET ild_exw = ild_exwmi * NEW.op_tcambio, ild_total = (ild_exwmi * NEW.op_tcambio) * ild_cantidad
  WHERE ild_proforma = NEW.op_nroorden;
    
    
END

DELIMITER //
CREATE TRIGGER ModificaDetalleImportacion AFTER UPDATE ON imp_proorden
 FOR EACH ROW BEGIN
  DECLARE tasa_Cambio, volton, peston, porton, totton DOUBLE(14,6);

  SET volton = ((NEW.pop_largo * NEW.pop_profundidad * NEW.pop_alto) / 1000000) / 2000;  
  SET peston = NEW.pop_peso / 2000;
  
  IF(peston >= volton) THEN
    SET porton = peston;
  ELSE
    SET porton = volton;
  END IF;
  SET totton = porton * NEW.pop_cantidad;
  SELECT op_tcambio INTO tasa_Cambio FROM imp_opedido WHERE op_nroorden = NEW.pop_cproforma;

  UPDATE imp_liqdetalle SET ild_exwmi = NEW.pop_costounitario, ild_totalmi = NEW.pop_costounitario *  NEW.pop_cantidad,
  ild_exw = NEW.pop_costounitario * tasa_Cambio, ild_total = (NEW.pop_costounitario * tasa_Cambio) *  NEW.pop_cantidad, ild_partida = NEW.pop_partida, ild_preferencia = NEW.pop_preferencia, ild_pesokg = NEW.pop_peso, ild_alto = NEW.pop_alto, ild_profundidad = NEW.pop_profundidad, ild_largo = NEW.pop_largo, ild_volumenton = volton, ild_pesoton = peston, ild_pesovolton = porton, ild_totalpesvol = totton
  WHERE ild_proforma = NEW.pop_cproforma AND ild_cinterno = NEW.pop_codproducto;
END


DELIMITER //
CREATE PROCEDURE CalculoGastos(IN proforma INTEGER)
BEGIN
  DECLARE done INT DEFAULT 0;
  DECLARE por_saldivisa, val_saldivisa, lim_corpei, val_corpei, por_corpei, val_tcambio, val_gnacionales, val_exworkmn DOUBLE(14,2) DEFAULT 0;
  DECLARE val_gastosmn, val_fletemn, val_seguromn, val_totalmn, val_exworkmi, val_gastosmi, val_fletemi, val_seguromi DOUBLE(14,2) DEFAULT 0;
  DECLARE val_totalmi, val_divisa, valor_corpei, Gfob, por_iva DOUBLE(14,2) DEFAULT 0;

  DECLARE qlar_partida VARCHAR(15);
  DECLARE qlar_preferencia VARCHAR(3);
  DECLARE qlar_proforma INT DEFAULT 0;
  DECLARE qlar_nroorden VARCHAR(45);
  DECLARE qlar_pexwork, qlar_ptoneladas DOUBLE(9,5) DEFAULT 0;
  DECLARE qlar_exw, qlar_sumatoria, qlar_sumatoriaton, qlar_alicota, qlar_alicotaton, qlar_advalorem, qlar_fodinfa, qlar_control, qlar_modernizacion, qlar_valsalvaguardia, qlar_porice DOUBLE(14,2) DEFAULT 0;
  DECLARE qlar_salvaguardia, qlar_iva, qlar_ice, qlar_corpei CHAR(1);

  DECLARE gas_codigo, gas_obligaciones, gas_volumen, gas_cerrarimp, gas_iva INT DEFAULT 0;
  DECLARE gas_descripcion VARCHAR(255);

  DECLARE por_exwork, por_toneladas DOUBLE(14,2) DEFAULT 0;
  DECLARE cif_exwork, cif_toneladas DOUBLE(14,2) DEFAULT 0;
  DECLARE valor_advalorem, valor_cif, valor_fodinfa, valor_modernizacion, valor_control, valor_iva, valor_ice DOUBLE(14,2) DEFAULT 0;
  DECLARE cod_advalorem, cod_fodinfa, cod_modernizacion, cod_control, cod_divisas, cod_seguro, cod_ice DOUBLE(14,2) DEFAULT 0;
  DECLARE valorton_advalorem, valorton_cif, valorton_fodinfa, valorton_modernizacion, valorton_control, valorton_iva, valorton_ice DOUBLE(14,2) DEFAULT 0;

  DECLARE cur1 CURSOR FOR SELECT * FROM imp_gastos WHERE gas_obligaciones = 1;
  DECLARE cur2 CURSOR FOR SELECT * FROM imp_liqarancel WHERE lar_proforma = proforma;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  SELECT sucursal_1 INTO por_iva FROM parametros WHERE nparametro LIKE '%IVA%';
  SELECT sucursal_1 INTO por_saldivisa FROM imp_parametros WHERE nparametro LIKE '%porcentaje_salida_divisas%';
  SELECT sucursal_1 INTO val_saldivisa FROM imp_parametros WHERE nparametro LIKE '%valor_exonerado_salida_divisas%';
  SELECT sucursal_1 INTO lim_corpei FROM imp_parametros WHERE nparametro LIKE '%limitante_corpei%';
  SELECT sucursal_1 INTO val_corpei FROM imp_parametros WHERE nparametro LIKE '%valcorpei%';
  SELECT sucursal_1 INTO por_corpei FROM imp_parametros WHERE nparametro LIKE '%porce_corpei%';

  SELECT op_tcambio, op_gnacionales, op_exworkmn, op_gastosmn, op_fletemn, op_seguromn, op_totalmn, op_exworkmi, op_gastosmi, op_fletemi, op_seguromi, op_totalmi
  INTO val_tcambio, val_gnacionales, val_exworkmn, val_gastosmn, val_fletemn, val_seguromn, val_totalmn, val_exworkmi, val_gastosmi, val_fletemi, val_seguromi, val_totalmi
  FROM imp_opedido WHERE op_nroorden = proforma;

  DELETE FROM imp_liqarancel WHERE lar_proforma = proforma;
  INSERT INTO imp_liqarancel
  SELECT ild_partida, ild_preferencia, ild_proforma, ild_nroorden, SUM(val_exworkmn/(ild_cantidad * ild_exw)), SUM(val_exworkmn/(ild_totalpesvol)), val_exworkmn, SUM( ild_cantidad * ild_exw ), sum( ild_totalpesvol ), 0, 0, advaloren, fodinfa, control, modernizacion, salvaguardia, iva, ice, corpei, valsalvaguardia, valice
  FROM imp_liqdetalle
  INNER JOIN imp_liqcabecera ON ilc_proforma = ild_proforma
  INNER JOIN imp_aranceles ON ild_partida = ara_codigoaran AND ild_preferencia = ara_preferencia
  INNER JOIN provedor ON provcod = ilc_proveedor
  INNER JOIN imp_nacionarancel ON procodnacion = nacion_codigo AND arancel_codigo = ara_codigo
  WHERE ild_proforma = proforma GROUP BY ild_partida, ild_preferencia;

  IF val_totalmn > val_saldivisa THEN
    SET val_divisa = (val_totalmn-val_saldivisa) * (por_saldivisa/100);
  ELSE
    SET val_divisa = (val_totalmn) * (por_saldivisa/100);
  END IF;

  SET Gfob = val_exworkmn + val_gastosmn;
  IF Gfob <= lim_corpei THEN
    SET valor_corpei = val_corpei;
  ELSE
    SET valor_corpei = Gfob * (por_corpei/100);
  END IF;

  OPEN cur2;
  REPEAT
  FETCH cur2 INTO qlar_partida, qlar_preferencia, qlar_proforma, qlar_nroorden, qlar_pexwork, qlar_ptoneladas, qlar_exw, qlar_sumatoria, qlar_sumatoriaton, qlar_alicota, qlar_alicotaton, qlar_advalorem, qlar_fodinfa, qlar_control, qlar_modernizacion, qlar_salvaguardia, qlar_iva, qlar_ice, qlar_corpei, qlar_valsalvaguardia, qlar_porice;
  IF NOT done THEN
    SET por_exwork = qlar_pexwork / 100;
    SET por_toneladas = qlar_ptoneladas / 100;
    SET cif_exwork = (qlar_exw * por_exwork)+(val_exworkmn * por_exwork)+(val_gastosmn * por_exwork)+(val_fletemn * por_exwork)+(val_seguromn * por_exwork);
    SET cif_toneladas = (qlar_exw * por_toneladas)+(val_exworkmn * por_exwork)+(val_gastosmn * por_exwork)+(val_fletemn * por_exwork)+(val_seguromn * por_exwork);
    UPDATE imp_liqarancel SET lar_sumatoria = cif_exwork, lar_sumatoriaton = cif_toneladas WHERE lar_partida = qlar_partida AND lar_preferencia = qlar_preferencia AND lar_proforma = proforma;
  END IF;
  UNTIL done END REPEAT;
  CLOSE cur2;

  SET done = 0;
  OPEN cur1;
  REPEAT
  FETCH cur1 INTO gas_codigo, gas_descripcion, gas_obligaciones, gas_volumen, gas_cerrarimp, gas_iva;
  IF NOT done THEN
    SET valor_iva = 0;
    CASE gas_descripcion
      WHEN 'ADVALOREM' THEN
        SET cod_advalorem = gas_codigo;
        SELECT SUM(lar_sumatoria * (lar_advalorem / 100)) INTO valor_advalorem FROM imp_liqarancel WHERE lar_proforma = proforma;
        SELECT SUM(lar_sumatoria * (lar_advalorem / 100)) INTO valorton_advalorem FROM imp_liqarancel WHERE lar_proforma = proforma;
      WHEN 'FODINFA' THEN
        SET cod_fodinfa = gas_codigo;
        SELECT SUM(lar_sumatoria * (lar_fodinfa / 100)) INTO valor_fodinfa FROM imp_liqarancel WHERE lar_proforma = proforma;
        SELECT SUM(lar_sumatoria * (lar_fodinfa / 100)) INTO valorton_fodinfa FROM imp_liqarancel WHERE lar_proforma = proforma;
      WHEN 'MODERNIZACION' THEN
        SET cod_modernizacion = gas_codigo;
        SELECT SUM(lar_sumatoria * (lar_modernizacion / 100)) INTO valor_modernizacion FROM imp_liqarancel WHERE lar_proforma = proforma;
        SELECT SUM(lar_sumatoria * (lar_modernizacion / 100)) INTO valorton_modernizacion FROM imp_liqarancel WHERE lar_proforma = proforma;
      WHEN 'CONTROL' THEN
        SET cod_control = gas_codigo;
        SELECT SUM(lar_sumatoria * (lar_control / 100)) INTO valor_control FROM imp_liqarancel WHERE lar_proforma = proforma;
        SELECT SUM(lar_sumatoria * (lar_control / 100)) INTO valorton_control FROM imp_liqarancel WHERE lar_proforma = proforma;
      WHEN 'ICE' THEN
        SET cod_ice = gas_codigo;
        SELECT SUM(lar_sumatoria * (lar_porice / 100)) INTO valor_ice FROM imp_liqarancel WHERE lar_proforma = proforma;
        SELECT SUM(lar_sumatoria * (lar_porice / 100)) INTO valor_ice FROM imp_liqarancel WHERE lar_proforma = proforma;
      WHEN 'IMPUESTO SALIDA DIVISAS' THEN
        SET cod_divisas = gas_codigo;
    END CASE;
  END IF;
  UNTIL done END REPEAT;
  CLOSE cur1;

  INSERT INTO imp_gatosop (gop_codgasto, gop_cproforma, gop_presupuesto, gtn_ivapresup ) VALUES (cod_divisas, proforma, val_divisa, 0)
  ON DUPLICATE KEY UPDATE gop_presupuesto = val_divisa, gtn_ivapresup = 0;

  SET valor_iva = (val_exworkmn+valor_advalorem + valor_fodinfa + valor_modernizacion + valor_control) * (por_iva/100);
  INSERT INTO imp_gatosop (gop_codgasto, gop_cproforma, gop_presupuesto, gtn_ivapresup ) VALUES (cod_advalorem, proforma, valor_advalorem, valor_iva)
  ON DUPLICATE KEY UPDATE gop_presupuesto = valor_advalorem, gtn_ivapresup = valor_iva;

  INSERT INTO imp_gatosop (gop_codgasto, gop_cproforma, gop_presupuesto, gtn_ivapresup ) VALUES (cod_fodinfa, proforma, valor_fodinfa, 0)
  ON DUPLICATE KEY UPDATE gop_presupuesto = valor_fodinfa, gtn_ivapresup = 0;

  IF valor_modernizacion > 0 THEN
    INSERT INTO imp_gatosop (gop_codgasto, gop_cproforma, gop_presupuesto, gtn_ivapresup ) VALUES (cod_modernizacion, proforma, valor_modernizacion, 0)
    ON DUPLICATE KEY UPDATE gop_presupuesto = valor_modernizacion, gtn_ivapresup = 0;
  ELSE
    DELETE FROM imp_gatosop WHERE gop_cproforma = proforma AND gop_codgasto = cod_modernizacion;
  END IF;
  IF valor_control > 0 THEN
    INSERT INTO imp_gatosop (gop_codgasto, gop_cproforma, gop_presupuesto, gtn_ivapresup ) VALUES (cod_control, proforma, valor_control, 0)
    ON DUPLICATE KEY UPDATE gop_presupuesto = valor_control, gtn_ivapresup = 0;
  ELSE
    DELETE FROM imp_gatosop WHERE gop_cproforma = proforma AND gop_codgasto = cod_control;
  END IF;
  IF valor_ice > 0 THEN
    INSERT INTO imp_gatosop (gop_codgasto, gop_cproforma, gop_presupuesto, gtn_ivapresup ) VALUES (cod_ice, proforma, valor_ice, 0)
    ON DUPLICATE KEY UPDATE gop_presupuesto = valor_ice, gtn_ivapresup = 0;
  ELSE
    DELETE FROM imp_gatosop WHERE gop_cproforma = proforma AND gop_codgasto = cod_ice;
  END IF;
END


DELIMITER //
CREATE PROCEDURE CalculoPresupuestoImportacion(IN proforma INTEGER)
BEGIN
  DECLARE done INT DEFAULT 0;
  DECLARE vgas_descripcion VARCHAR(45);
  DECLARE vpresupuesto, vsubtotal, votrosgastos, vadvalorem, vfodinfa, vmodernizacion, vcontrol, vice, vimpsalida, vsalvaguardia, vseguro, vcorpei, vfleteint DOUBLE(14,2) DEFAULT 0;
  DECLARE vprovcod, vilc_tnego, vter_fleteint, vter_seguroint, vter_gastonac, vter_gastoint INT  DEFAULT 0;
  DECLARE vilc_texw, vilc_tgastosfob, vilc_tfletes, vilc_tseguro, vilc_tgastosop, vop_exworkmn, vop_gastosmn, vop_fletemn, vop_seguromn DOUBLE(14,2) DEFAULT 0;
  DECLARE vilc_tcambio, vild_porexwork, vild_portoneladas DOUBLE(14,4) DEFAULT 0;
  DECLARE vilc_estado3 CHAR;
  DECLARE vild_partida, vild_cinterno VARCHAR(20);
  DECLARE vild_preferencia VARCHAR(3);

  DECLARE cur_gastos CURSOR FOR SELECT gas_descripcion, SUM(gop_presupuesto), sum(gtn_subtotal)
  FROM `imp_gatosop` INNER JOIN imp_gastos ON gas_codigo = gop_codgasto
  WHERE  gop_cproforma = proforma GROUP BY gop_codgasto;

  DECLARE cur_liqdetalle CURSOR FOR SELECT ild_partida, ild_preferencia, ild_cinterno, ild_porexwork, ild_portoneladas FROM `imp_liqdetalle` WHERE ild_proforma = proforma;

  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  SELECT provcod, vilc_estado3, ilc_tnego, ilc_tcambio, ilc_texw, ilc_tgastosfob, ilc_tfletes, ilc_tseguro, ilc_tgastosop, ter_gastoint, ter_fleteint, ter_seguroint, ter_gastonac, op_exworkmn, op_gastosmn, op_fletemn, op_seguromn
  INTO vprovcod, vilc_tnego, vilc_tcambio, vilc_texw, vilc_tgastosfob, vilc_tfletes, vilc_tseguro, vilc_tgastosop, vter_gastoint, vter_fleteint, vter_seguroint, vter_gastonac, vop_exworkmn, vop_gastosmn, vop_fletemn, vop_seguromn
  FROM `imp_liqcabecera`
  INNER JOIN `provedor` ON ilc_proveedor = provedor.provcod
  INNER JOIN `imp_opedido` ON ilc_proforma = op_nroorden
  INNER JOIN `imp_terminos` ON ter_codigo = ilc_tnego
  WHERE ilc_proforma = proforma;

  OPEN cur_gastos;
  REPEAT
  FETCH cur_gastos INTO vgas_descripcion, vpresupuesto, vsubtotal;
  IF NOT done THEN
    CASE vgas_descripcion
      WHEN 'ADVALOREM' THEN
        SET vadvalorem = vpresupuesto;
      WHEN 'FODINFA' THEN
        SET vfodinfa = vpresupuesto;
      WHEN 'MODERNIZACION' THEN
        SET vmodernizacion = vpresupuesto;
      WHEN 'CONTROL' THEN
        SET vcontrol = vpresupuesto;
      WHEN 'ICE' THEN
        SET vice = vpresupuesto;
      WHEN 'IMPUESTO SALIDA DIVISAS' THEN
        SET vimpsalida = vpresupuesto;
      WHEN 'SALVAGUARDIA' THEN
        SET vsalvaguardia = vpresupuesto;
      WHEN 'SEGURO' THEN
        SET vseguro = vpresupuesto;
      WHEN 'CORPEI' THEN
        SET vcorpei = vpresupuesto;
      WHEN 'FLETE INTERNACIONAL' THEN
        SET vfleteint = vpresupuesto;
      ELSE
        SET votrosgastos = vpresupuesto;
    END CASE;
  END IF;
  UNTIL done END REPEAT;
  CLOSE cur_gastos;

  SET done = 0;

  OPEN cur_liqdetalle;
  REPEAT
  FETCH cur_liqdetalle INTO vild_partida, vild_preferencia, vild_cinterno, vild_porexwork, vild_portoneladas;
  IF NOT done THEN
    UPDATE imp_liqdetalle SET ild_proadvalorem = vild_porexwork * vadvalorem, ild_profodinfa = vild_porexwork * vfodinfa, ild_procorpei = vild_porexwork * vcorpei,
    ild_prosalvaguradia = vild_porexwork * vsalvaguardia, ild_procontrol = vild_porexwork * vcontrol, ild_promodernizacion = vild_porexwork * vmodernizacion,
    ild_proice = vild_porexwork * vice, ild_proglocales = vild_porexwork * (votrosgastos + vfleteint + vseguro + vilc_tfletes + vilc_tseguro + vilc_tgastosop),
    ild_proadvaloremton = vild_portoneladas * vadvalorem, ild_profodinfaton = vild_portoneladas * vfodinfa,
    ild_procorpeiton = vild_portoneladas * vcorpei, ild_prosalvaguradiaton = vild_portoneladas * vsalvaguardia,
    ild_procontrolton = vild_portoneladas * vcontrol, ild_promodernizacionton = vild_portoneladas * vmodernizacion,
    ild_proiceton = vild_portoneladas * vice, ild_proglocaleston = vild_portoneladas * (votrosgastos + vfleteint + vseguro + vilc_tfletes + vilc_tseguro + vilc_tgastosfob)
    WHERE ild_proforma = proforma AND ild_cinterno = vild_cinterno;

    UPDATE imp_liqdetalle SET
    ild_sumatoria = SUM(ild_exw + ild_proadvalorem + ild_profodinfa + ild_procorpei + ild_prosalvaguradia + ild_procontrol + ild_promodernizacion + ild_proice + ild_proglocales),
    ild_sumatoriaton = SUM(ild_exw + ild_proadvaloremton + ild_profodinfaton + ild_procorpeiton + ild_prosalvaguradiaton + ild_procontrolton + ild_promodernizacionton + ild_proiceton + ild_proglocaleston)
    WHERE ild_proforma = proforma AND ild_cinterno = vild_cinterno;

  END IF;
  UNTIL done END REPEAT;
  CLOSE cur_liqdetalle;


END;